// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.support.model.RefreshTrustedAdvisorCheckResponse
import aws.sdk.kotlin.services.support.model.SupportException
import aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckRefreshStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RefreshTrustedAdvisorCheckOperationDeserializer: HttpDeserialize<RefreshTrustedAdvisorCheckResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RefreshTrustedAdvisorCheckResponse {
        if (!response.status.isSuccess()) {
            throwRefreshTrustedAdvisorCheckError(context, response)
        }
        val builder = RefreshTrustedAdvisorCheckResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRefreshTrustedAdvisorCheckOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRefreshTrustedAdvisorCheckError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SupportException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SupportException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRefreshTrustedAdvisorCheckOperationBody(builder: RefreshTrustedAdvisorCheckResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STATUS_DESCRIPTOR.index -> builder.status = deserializeTrustedAdvisorCheckRefreshStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
