// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.support.model.*
import aws.sdk.kotlin.services.support.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Support"
const val ServiceApiVersion: String = "2013-04-15"
const val SdkVersion: String = "0.17.0-beta"

internal class DefaultSupportClient(override val config: SupportClient.Config) : SupportClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds one or more attachments to an attachment set.
     *
     * An attachment set is a temporary container for attachments that you add to a case or case communication. The set is available for 1 hour after it's created. The `expiryTime` returned in the response is when the set expires.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun addAttachmentsToSet(input: AddAttachmentsToSetRequest): AddAttachmentsToSetResponse {
        val op = SdkHttpOperation.build<AddAttachmentsToSetRequest, AddAttachmentsToSetResponse> {
            serializer = AddAttachmentsToSetOperationSerializer()
            deserializer = AddAttachmentsToSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddAttachmentsToSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds additional customer communication to an Amazon Web Services Support case. Use the `caseId` parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the `ccEmailAddresses` parameter. The `communicationBody` value contains the text of the communication.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun addCommunicationToCase(input: AddCommunicationToCaseRequest): AddCommunicationToCaseResponse {
        val op = SdkHttpOperation.build<AddCommunicationToCaseRequest, AddCommunicationToCaseResponse> {
            serializer = AddCommunicationToCaseOperationSerializer()
            deserializer = AddCommunicationToCaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddCommunicationToCase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
     *
     * The Amazon Web Services Support API doesn't support requesting service limit increases. You can submit a service limit increase in the following ways:
     * + Submit a request from the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
     * + Use the Service Quotas [RequestServiceQuotaIncrease](https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html) operation.
     *
     * A successful `CreateCase` request returns an Amazon Web Services Support case number. You can use the DescribeCases operation and specify the case number to get existing Amazon Web Services Support cases. After you create a case, use the AddCommunicationToCase operation to add additional communication or attachments to an existing case.
     *
     * The `caseId` is separate from the `displayId` that appears in the [Amazon Web Services Support Center](https://console.aws.amazon.com/support). Use the DescribeCases operation to get the `displayId`.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun createCase(input: CreateCaseRequest): CreateCaseResponse {
        val op = SdkHttpOperation.build<CreateCaseRequest, CreateCaseResponse> {
            serializer = CreateCaseOperationSerializer()
            deserializer = CreateCaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the AttachmentDetails objects that are returned by the DescribeCommunications operation.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeAttachment(input: DescribeAttachmentRequest): DescribeAttachmentResponse {
        val op = SdkHttpOperation.build<DescribeAttachmentRequest, DescribeAttachmentResponse> {
            serializer = DescribeAttachmentOperationSerializer()
            deserializer = DescribeAttachmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAttachment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of cases that you specify by passing one or more case IDs. You can use the `afterTime` and `beforeTime` parameters to filter the cases by date. You can set values for the `includeResolvedCases` and `includeCommunications` parameters to specify how much information to return.
     *
     * The response returns the following in JSON format:
     * + One or more [CaseDetails](https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html) data types.
     * + One or more `nextToken` values, which specify where to paginate the returned records represented by the `CaseDetails` objects.
     *
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request might return an error.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeCases(input: DescribeCasesRequest): DescribeCasesResponse {
        val op = SdkHttpOperation.build<DescribeCasesRequest, DescribeCasesResponse> {
            serializer = DescribeCasesOperationSerializer()
            deserializer = DescribeCasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns communications and attachments for one or more support cases. Use the `afterTime` and `beforeTime` parameters to filter by date. You can use the `caseId` parameter to restrict the results to a specific case.
     *
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error.
     *
     * You can use the `maxResults` and `nextToken` parameters to control the pagination of the results. Set `maxResults` to the number of cases that you want to display on each page, and use `nextToken` to specify the resumption of pagination.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeCommunications(input: DescribeCommunicationsRequest): DescribeCommunicationsResponse {
        val op = SdkHttpOperation.build<DescribeCommunicationsRequest, DescribeCommunicationsResponse> {
            serializer = DescribeCommunicationsOperationSerializer()
            deserializer = DescribeCommunicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCommunications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the current list of Amazon Web Services services and a list of service categories for each service. You then use service names and categories in your CreateCase requests. Each Amazon Web Services service has its own set of categories.
     *
     * The service codes and category codes correspond to the values that appear in the **Service** and **Category** lists on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page. The values in those fields don't necessarily match the service codes and categories returned by the `DescribeServices` operation. Always use the service codes and categories that the `DescribeServices` operation returns, so that you have the most recent set of service and category codes.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeServices(input: DescribeServicesRequest): DescribeServicesResponse {
        val op = SdkHttpOperation.build<DescribeServicesRequest, DescribeServicesResponse> {
            serializer = DescribeServicesOperationSerializer()
            deserializer = DescribeServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the CaseDetails data type that you include for a CreateCase request.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeSeverityLevels(input: DescribeSeverityLevelsRequest): DescribeSeverityLevelsResponse {
        val op = SdkHttpOperation.build<DescribeSeverityLevelsRequest, DescribeSeverityLevelsResponse> {
            serializer = DescribeSeverityLevelsOperationSerializer()
            deserializer = DescribeSeverityLevelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSeverityLevels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * Some checks are refreshed automatically, and you can't return their refresh statuses by using the `DescribeTrustedAdvisorCheckRefreshStatuses` operation. If you call this operation for these checks, you might see an `InvalidParameterValue` error.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeTrustedAdvisorCheckRefreshStatuses(input: DescribeTrustedAdvisorCheckRefreshStatusesRequest): DescribeTrustedAdvisorCheckRefreshStatusesResponse {
        val op = SdkHttpOperation.build<DescribeTrustedAdvisorCheckRefreshStatusesRequest, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
            serializer = DescribeTrustedAdvisorCheckRefreshStatusesOperationSerializer()
            deserializer = DescribeTrustedAdvisorCheckRefreshStatusesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrustedAdvisorCheckRefreshStatuses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * The response contains a TrustedAdvisorCheckResult object, which contains these three objects:
     * + TrustedAdvisorCategorySpecificSummary
     * + TrustedAdvisorResourceDetail
     * + TrustedAdvisorResourcesSummary
     *
     * In addition, the response contains these fields:
     * + **status** - The alert status of the check can be `ok` (green), `warning` (yellow), `error` (red), or `not_available`.
     * + **timestamp** - The time of the last refresh of the check.
     * + **checkId** - The unique identifier for the check.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeTrustedAdvisorCheckResult(input: DescribeTrustedAdvisorCheckResultRequest): DescribeTrustedAdvisorCheckResultResponse {
        val op = SdkHttpOperation.build<DescribeTrustedAdvisorCheckResultRequest, DescribeTrustedAdvisorCheckResultResponse> {
            serializer = DescribeTrustedAdvisorCheckResultOperationSerializer()
            deserializer = DescribeTrustedAdvisorCheckResultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrustedAdvisorCheckResult"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * The response contains an array of TrustedAdvisorCheckSummary objects.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun describeTrustedAdvisorCheckSummaries(input: DescribeTrustedAdvisorCheckSummariesRequest): DescribeTrustedAdvisorCheckSummariesResponse {
        val op = SdkHttpOperation.build<DescribeTrustedAdvisorCheckSummariesRequest, DescribeTrustedAdvisorCheckSummariesResponse> {
            serializer = DescribeTrustedAdvisorCheckSummariesOperationSerializer()
            deserializer = DescribeTrustedAdvisorCheckSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrustedAdvisorCheckSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code. The Amazon Web Services Support API currently supports English ("en") and Japanese ("ja"). The response contains a TrustedAdvisorCheckDescription object for each check. You must set the Amazon Web Services Region to us-east-1.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     * + The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the check ID in your code to uniquely identify a check.
     */
    override suspend fun describeTrustedAdvisorChecks(input: DescribeTrustedAdvisorChecksRequest): DescribeTrustedAdvisorChecksResponse {
        val op = SdkHttpOperation.build<DescribeTrustedAdvisorChecksRequest, DescribeTrustedAdvisorChecksResponse> {
            serializer = DescribeTrustedAdvisorChecksOperationSerializer()
            deserializer = DescribeTrustedAdvisorChecksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTrustedAdvisorChecks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * Some checks are refreshed automatically. If you call the `RefreshTrustedAdvisorCheck` operation to refresh them, you might see the `InvalidParameterValue` error.
     *
     * The response contains a TrustedAdvisorCheckRefreshStatus object.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun refreshTrustedAdvisorCheck(input: RefreshTrustedAdvisorCheckRequest): RefreshTrustedAdvisorCheckResponse {
        val op = SdkHttpOperation.build<RefreshTrustedAdvisorCheckRequest, RefreshTrustedAdvisorCheckResponse> {
            serializer = RefreshTrustedAdvisorCheckOperationSerializer()
            deserializer = RefreshTrustedAdvisorCheckOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RefreshTrustedAdvisorCheck"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resolves a support case. This operation takes a `caseId` and returns the initial and final state of the case.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that does not have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    override suspend fun resolveCase(input: ResolveCaseRequest): ResolveCaseResponse {
        val op = SdkHttpOperation.build<ResolveCaseRequest, ResolveCaseResponse> {
            serializer = ResolveCaseOperationSerializer()
            deserializer = ResolveCaseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResolveCase"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSupport_20130415", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "support"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "support")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
