// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * A code and name pair that represents the severity level of a support case. The available values depend on the support plan for the account. For more information, see [Choosing a severity](https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity) in the *Amazon Web Services Support User Guide*.
 */
class SeverityLevel private constructor(builder: Builder) {
    /**
     * The code for case severity level.
     *
     * Valid values: `low` | `normal` | `high` | `urgent` | `critical`
     */
    val code: kotlin.String? = builder.code
    /**
     * The name of the severity level that corresponds to the severity level code.
     *
     * The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code `low`, but the name appears as General guidance in Support Center.
     *
     * The following are the API code names and how they appear in the console:
     * + `low` - General guidance
     * + `normal` - System impaired
     * + `high` - Production system impaired
     * + `urgent` - Production system down
     * + `critical` - Business-critical system down
     * For more information, see [Choosing a severity](https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity) in the *Amazon Web Services Support User Guide*.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.SeverityLevel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SeverityLevel(")
        append("code=$code,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SeverityLevel

        if (code != other.code) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.SeverityLevel = Builder(this).apply(block).build()

    class Builder {
        /**
         * The code for case severity level.
         *
         * Valid values: `low` | `normal` | `high` | `urgent` | `critical`
         */
        var code: kotlin.String? = null
        /**
         * The name of the severity level that corresponds to the severity level code.
         *
         * The values returned by the API are different from the values that appear in the Amazon Web Services Support Center. For example, the API uses the code `low`, but the name appears as General guidance in Support Center.
         *
         * The following are the API code names and how they appear in the console:
         * + `low` - General guidance
         * + `normal` - System impaired
         * + `high` - Production system impaired
         * + `urgent` - Production system down
         * + `critical` - Business-critical system down
         * For more information, see [Choosing a severity](https://docs.aws.amazon.com/awssupport/latest/user/case-management.html#choosing-severity) in the *Amazon Web Services Support User Guide*.
         */
        var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.SeverityLevel) : this() {
            this.code = x.code
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.SeverityLevel = SeverityLevel(this)
    }
}
