// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources examined.
 */
class TrustedAdvisorCheckSummary private constructor(builder: Builder) {
    /**
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.
     */
    val categorySpecificSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary? = builder.categorySpecificSummary
    /**
     * The unique identifier for the Trusted Advisor check.
     */
    val checkId: kotlin.String? = builder.checkId
    /**
     * Specifies whether the Trusted Advisor check has flagged resources.
     */
    val hasFlaggedResources: kotlin.Boolean = builder.hasFlaggedResources
    /**
     * Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
     */
    val resourcesSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary? = builder.resourcesSummary
    /**
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    val status: kotlin.String? = builder.status
    /**
     * The time of the last refresh of the check.
     */
    val timestamp: kotlin.String? = builder.timestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustedAdvisorCheckSummary(")
        append("categorySpecificSummary=$categorySpecificSummary,")
        append("checkId=$checkId,")
        append("hasFlaggedResources=$hasFlaggedResources,")
        append("resourcesSummary=$resourcesSummary,")
        append("status=$status,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = categorySpecificSummary?.hashCode() ?: 0
        result = 31 * result + (checkId?.hashCode() ?: 0)
        result = 31 * result + (hasFlaggedResources.hashCode())
        result = 31 * result + (resourcesSummary?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustedAdvisorCheckSummary

        if (categorySpecificSummary != other.categorySpecificSummary) return false
        if (checkId != other.checkId) return false
        if (hasFlaggedResources != other.hasFlaggedResources) return false
        if (resourcesSummary != other.resourcesSummary) return false
        if (status != other.status) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.
         */
        var categorySpecificSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary? = null
        /**
         * The unique identifier for the Trusted Advisor check.
         */
        var checkId: kotlin.String? = null
        /**
         * Specifies whether the Trusted Advisor check has flagged resources.
         */
        var hasFlaggedResources: kotlin.Boolean = false
        /**
         * Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
         */
        var resourcesSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary? = null
        /**
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         */
        var status: kotlin.String? = null
        /**
         * The time of the last refresh of the check.
         */
        var timestamp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckSummary) : this() {
            this.categorySpecificSummary = x.categorySpecificSummary
            this.checkId = x.checkId
            this.hasFlaggedResources = x.hasFlaggedResources
            this.resourcesSummary = x.resourcesSummary
            this.status = x.status
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckSummary = TrustedAdvisorCheckSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary] inside the given [block]
         */
        fun categorySpecificSummary(block: aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary.Builder.() -> kotlin.Unit) {
            this.categorySpecificSummary = aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary] inside the given [block]
         */
        fun resourcesSummary(block: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary.Builder.() -> kotlin.Unit) {
            this.resourcesSummary = aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary.invoke(block)
        }
    }
}
