// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
 */
class TrustedAdvisorResourcesSummary private constructor(builder: Builder) {
    /**
     * The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.
     */
    val resourcesFlagged: kotlin.Long = builder.resourcesFlagged
    /**
     * The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.
     */
    val resourcesIgnored: kotlin.Long = builder.resourcesIgnored
    /**
     * The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.
     */
    val resourcesProcessed: kotlin.Long = builder.resourcesProcessed
    /**
     * The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.
     */
    val resourcesSuppressed: kotlin.Long = builder.resourcesSuppressed

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustedAdvisorResourcesSummary(")
        append("resourcesFlagged=$resourcesFlagged,")
        append("resourcesIgnored=$resourcesIgnored,")
        append("resourcesProcessed=$resourcesProcessed,")
        append("resourcesSuppressed=$resourcesSuppressed)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourcesFlagged.hashCode()
        result = 31 * result + (resourcesIgnored.hashCode())
        result = 31 * result + (resourcesProcessed.hashCode())
        result = 31 * result + (resourcesSuppressed.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustedAdvisorResourcesSummary

        if (resourcesFlagged != other.resourcesFlagged) return false
        if (resourcesIgnored != other.resourcesIgnored) return false
        if (resourcesProcessed != other.resourcesProcessed) return false
        if (resourcesSuppressed != other.resourcesSuppressed) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of Amazon Web Services resources that were flagged (listed) by the Trusted Advisor check.
         */
        var resourcesFlagged: kotlin.Long = 0L
        /**
         * The number of Amazon Web Services resources ignored by Trusted Advisor because information was unavailable.
         */
        var resourcesIgnored: kotlin.Long = 0L
        /**
         * The number of Amazon Web Services resources that were analyzed by the Trusted Advisor check.
         */
        var resourcesProcessed: kotlin.Long = 0L
        /**
         * The number of Amazon Web Services resources ignored by Trusted Advisor because they were marked as suppressed by the user.
         */
        var resourcesSuppressed: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary) : this() {
            this.resourcesFlagged = x.resourcesFlagged
            this.resourcesIgnored = x.resourcesIgnored
            this.resourcesProcessed = x.resourcesProcessed
            this.resourcesSuppressed = x.resourcesSuppressed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary = TrustedAdvisorResourcesSummary(this)
    }
}
