// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the ActivityTaskScheduled event.
 */
class ActivityTaskScheduledEventAttributes private constructor(builder: Builder) {
    /**
     * The unique ID of the activity task.
     */
    val activityId: kotlin.String? = builder.activityId
    /**
     * The type of the activity task.
     */
    val activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = builder.activityType
    /**
     * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.
     */
    val control: kotlin.String? = builder.control
    /**
     * The ID of the DecisionTaskCompleted event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The maximum time before which the worker processing this task must report progress by calling
     * RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. If
     * the worker subsequently attempts to record a heartbeat or return a result, it is ignored.
     */
    val heartbeatTimeout: kotlin.String? = builder.heartbeatTimeout
    /**
     * The input provided to the activity task.
     */
    val input: kotlin.String? = builder.input
    /**
     * The maximum amount of time for this activity task.
     */
    val scheduleToCloseTimeout: kotlin.String? = builder.scheduleToCloseTimeout
    /**
     * The maximum amount of time the activity task can wait to be assigned to a worker.
     */
    val scheduleToStartTimeout: kotlin.String? = builder.scheduleToStartTimeout
    /**
     * The maximum amount of time a worker may take to process the activity task.
     */
    val startToCloseTimeout: kotlin.String? = builder.startToCloseTimeout
    /**
     * The task list in which the activity task has been scheduled.
     */
    val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The priority to assign to the scheduled activity task. If set, this overrides any default
     * priority value that was assigned when the activity type was registered.
     * Valid values are integers that range from Java's Integer.MIN_VALUE
     * (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
     * For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority in the Amazon SWF Developer Guide.
     */
    val taskPriority: kotlin.String? = builder.taskPriority

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivityTaskScheduledEventAttributes(")
        append("activityId=$activityId,")
        append("activityType=$activityType,")
        append("control=$control,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("heartbeatTimeout=$heartbeatTimeout,")
        append("input=$input,")
        append("scheduleToCloseTimeout=$scheduleToCloseTimeout,")
        append("scheduleToStartTimeout=$scheduleToStartTimeout,")
        append("startToCloseTimeout=$startToCloseTimeout,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId?.hashCode() ?: 0
        result = 31 * result + (activityType?.hashCode() ?: 0)
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (heartbeatTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (scheduleToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (scheduleToStartTimeout?.hashCode() ?: 0)
        result = 31 * result + (startToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivityTaskScheduledEventAttributes

        if (activityId != other.activityId) return false
        if (activityType != other.activityType) return false
        if (control != other.control) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (heartbeatTimeout != other.heartbeatTimeout) return false
        if (input != other.input) return false
        if (scheduleToCloseTimeout != other.scheduleToCloseTimeout) return false
        if (scheduleToStartTimeout != other.scheduleToStartTimeout) return false
        if (startToCloseTimeout != other.startToCloseTimeout) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique ID of the activity task.
         */
        var activityId: kotlin.String? = null
        /**
         * The type of the activity task.
         */
        var activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = null
        /**
         * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.
         */
        var control: kotlin.String? = null
        /**
         * The ID of the DecisionTaskCompleted event corresponding to the decision that resulted in the scheduling of this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The maximum time before which the worker processing this task must report progress by calling
         * RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. If
         * the worker subsequently attempts to record a heartbeat or return a result, it is ignored.
         */
        var heartbeatTimeout: kotlin.String? = null
        /**
         * The input provided to the activity task.
         */
        var input: kotlin.String? = null
        /**
         * The maximum amount of time for this activity task.
         */
        var scheduleToCloseTimeout: kotlin.String? = null
        /**
         * The maximum amount of time the activity task can wait to be assigned to a worker.
         */
        var scheduleToStartTimeout: kotlin.String? = null
        /**
         * The maximum amount of time a worker may take to process the activity task.
         */
        var startToCloseTimeout: kotlin.String? = null
        /**
         * The task list in which the activity task has been scheduled.
         */
        var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The priority to assign to the scheduled activity task. If set, this overrides any default
         * priority value that was assigned when the activity type was registered.
         * Valid values are integers that range from Java's Integer.MIN_VALUE
         * (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
         * For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority in the Amazon SWF Developer Guide.
         */
        var taskPriority: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes) : this() {
            this.activityId = x.activityId
            this.activityType = x.activityType
            this.control = x.control
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.heartbeatTimeout = x.heartbeatTimeout
            this.input = x.input
            this.scheduleToCloseTimeout = x.scheduleToCloseTimeout
            this.scheduleToStartTimeout = x.scheduleToStartTimeout
            this.startToCloseTimeout = x.startToCloseTimeout
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes = ActivityTaskScheduledEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityType] inside the given [block]
         */
        fun activityType(block: aws.sdk.kotlin.services.swf.model.ActivityType.Builder.() -> kotlin.Unit) {
            this.activityType = aws.sdk.kotlin.services.swf.model.ActivityType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
