// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the CancelTimer decision.
 *
 * Access Control
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 *
 *
 * Use a Resource element with the domain name to limit the action to only
 * specified domains.
 *
 * Use an Action element to allow or deny permission to call this action.
 *
 * You cannot use an IAM policy to constrain this action's parameters.
 *
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the
 * parameter values fall outside the specified constraints, the action fails. The associated event attribute's
 * cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
 * <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.
 */
class CancelTimerDecisionAttributes private constructor(builder: Builder) {
    /**
     * The unique ID of the timer to cancel.
     */
    val timerId: kotlin.String? = builder.timerId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CancelTimerDecisionAttributes(")
        append("timerId=$timerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = timerId?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CancelTimerDecisionAttributes

        if (timerId != other.timerId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique ID of the timer to cancel.
         */
        var timerId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes) : this() {
            this.timerId = x.timerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes = CancelTimerDecisionAttributes(this)
    }
}
