// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the ContinueAsNewWorkflowExecution decision.
 *
 * Access Control
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 *
 *
 * Use a Resource element with the domain name to limit the action to only
 * specified domains.
 *
 * Use an Action element to allow or deny permission to call this action.
 *
 * Constrain the following parameters by using a Condition element with the
 * appropriate keys.
 *
 *
 *
 * tag – A tag used to identify the workflow execution
 *
 *
 * taskList – String constraint. The key is swf:taskList.name.
 *
 *
 * workflowType.version – String constraint. The key is swf:workflowType.version.
 *
 *
 *
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the
 * parameter values fall outside the specified constraints, the action fails. The associated event attribute's
 * cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
 * <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.
 */
class ContinueAsNewWorkflowExecutionDecisionAttributes private constructor(builder: Builder) {
    /**
     * If set, specifies the policy to use for the child workflow executions of the new execution if it is terminated
     * by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy
     * overrides the default child policy specified when registering the workflow type using
     * RegisterWorkflowType.
     * The supported child policies are:
     *
     *
     *
     * TERMINATE – The child executions are terminated.
     *
     *
     * REQUEST_CANCEL – A request to cancel is attempted for each child
     * execution by recording a WorkflowExecutionCancelRequested event in its history. It is up to the decider
     * to take appropriate actions when it receives an execution history with this event.
     *
     *
     * ABANDON – No action is taken. The child executions continue to run.
     *
     *
     * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
     */
    val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = builder.childPolicy
    /**
     * If set, specifies the total duration for this workflow execution. This overrides the
     * defaultExecutionStartToCloseTimeout specified when registering the workflow type.
     * The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration.
     *
     * An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this field. If neither this field is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.
     */
    val executionStartToCloseTimeout: kotlin.String? = builder.executionStartToCloseTimeout
    /**
     * The input provided to the new workflow execution.
     */
    val input: kotlin.String? = builder.input
    /**
     * The IAM role to attach to the new (continued) execution.
     */
    val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The list of tags to associate with the new workflow execution. A maximum of 5 tags can be specified. You can
     * list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or
     * ListClosedWorkflowExecutions and specifying a TagFilter.
     */
    val tagList: List<String>? = builder.tagList
    /**
     * The task list to use for the decisions of the new (continued) workflow
     * execution.
     */
    val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The task priority that, if set, specifies the priority for the decision tasks for this workflow
     * execution. This overrides the defaultTaskPriority specified when registering the workflow type.
     * Valid values are integers that range from Java's Integer.MIN_VALUE
     * (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
     * For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority  in the Amazon SWF Developer Guide.
     */
    val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * Specifies the maximum duration of decision tasks for the new workflow execution. This parameter overrides the
     * defaultTaskStartToCloseTimout specified when registering the workflow type using
     * RegisterWorkflowType.
     * The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration.
     *
     * A task start-to-close timeout for the new workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.
     */
    val taskStartToCloseTimeout: kotlin.String? = builder.taskStartToCloseTimeout
    /**
     * The version of the workflow to start.
     */
    val workflowTypeVersion: kotlin.String? = builder.workflowTypeVersion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContinueAsNewWorkflowExecutionDecisionAttributes(")
        append("childPolicy=$childPolicy,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("input=$input,")
        append("lambdaRole=$lambdaRole,")
        append("tagList=$tagList,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout,")
        append("workflowTypeVersion=$workflowTypeVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy?.hashCode() ?: 0
        result = 31 * result + (executionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (workflowTypeVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContinueAsNewWorkflowExecutionDecisionAttributes

        if (childPolicy != other.childPolicy) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (input != other.input) return false
        if (lambdaRole != other.lambdaRole) return false
        if (tagList != other.tagList) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false
        if (workflowTypeVersion != other.workflowTypeVersion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * If set, specifies the policy to use for the child workflow executions of the new execution if it is terminated
         * by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy
         * overrides the default child policy specified when registering the workflow type using
         * RegisterWorkflowType.
         * The supported child policies are:
         *
         *
         *
         * TERMINATE – The child executions are terminated.
         *
         *
         * REQUEST_CANCEL – A request to cancel is attempted for each child
         * execution by recording a WorkflowExecutionCancelRequested event in its history. It is up to the decider
         * to take appropriate actions when it receives an execution history with this event.
         *
         *
         * ABANDON – No action is taken. The child executions continue to run.
         *
         *
         * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
         */
        var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * If set, specifies the total duration for this workflow execution. This overrides the
         * defaultExecutionStartToCloseTimeout specified when registering the workflow type.
         * The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration.
         *
         * An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this field. If neither this field is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.
         */
        var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The input provided to the new workflow execution.
         */
        var input: kotlin.String? = null
        /**
         * The IAM role to attach to the new (continued) execution.
         */
        var lambdaRole: kotlin.String? = null
        /**
         * The list of tags to associate with the new workflow execution. A maximum of 5 tags can be specified. You can
         * list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or
         * ListClosedWorkflowExecutions and specifying a TagFilter.
         */
        var tagList: List<String>? = null
        /**
         * The task list to use for the decisions of the new (continued) workflow
         * execution.
         */
        var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The task priority that, if set, specifies the priority for the decision tasks for this workflow
         * execution. This overrides the defaultTaskPriority specified when registering the workflow type.
         * Valid values are integers that range from Java's Integer.MIN_VALUE
         * (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
         * For more information about setting task priority, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task Priority  in the Amazon SWF Developer Guide.
         */
        var taskPriority: kotlin.String? = null
        /**
         * Specifies the maximum duration of decision tasks for the new workflow execution. This parameter overrides the
         * defaultTaskStartToCloseTimout specified when registering the workflow type using
         * RegisterWorkflowType.
         * The duration is specified in seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited duration.
         *
         * A task start-to-close timeout for the new workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.
         */
        var taskStartToCloseTimeout: kotlin.String? = null
        /**
         * The version of the workflow to start.
         */
        var workflowTypeVersion: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes) : this() {
            this.childPolicy = x.childPolicy
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.input = x.input
            this.lambdaRole = x.lambdaRole
            this.tagList = x.tagList
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
            this.workflowTypeVersion = x.workflowTypeVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes = ContinueAsNewWorkflowExecutionDecisionAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
