// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Specifies a decision made by the decider. A decision can be one of these types:
 *
 *
 *
 * CancelTimer – Cancels a previously started timer and records a TimerCanceled event in the
 * history.
 *
 *
 * CancelWorkflowExecution – Closes the workflow execution and records a
 * WorkflowExecutionCanceled event in the history.
 *
 *
 * CompleteWorkflowExecution – Closes the workflow execution and records a
 * WorkflowExecutionCompleted event in the history .
 *
 *
 * ContinueAsNewWorkflowExecution – Closes the workflow execution and starts a new workflow execution of the
 * same type using the same workflow ID and a unique run Id. A WorkflowExecutionContinuedAsNew event
 * is recorded in the history.
 *
 *
 * FailWorkflowExecution – Closes the workflow execution and records a WorkflowExecutionFailed
 * event in the history.
 *
 *
 * RecordMarker – Records a MarkerRecorded event in the history. Markers can be used for adding
 * custom information in the history for instance to let deciders know that they don't need to look at the history
 * beyond the marker event.
 *
 *
 * RequestCancelActivityTask – Attempts to cancel a previously scheduled activity task. If the activity task
 * was scheduled but has not been assigned to a worker, then it is canceled. If the activity task was already
 * assigned to a worker, then the worker is informed that cancellation has been requested in the response to
 * RecordActivityTaskHeartbeat.
 *
 *
 * RequestCancelExternalWorkflowExecution – Requests that a request be made to cancel the specified external
 * workflow execution and records a RequestCancelExternalWorkflowExecutionInitiated event in the
 * history.
 *
 *
 * ScheduleActivityTask – Schedules an activity task.
 *
 *
 * SignalExternalWorkflowExecution – Requests a signal to be delivered to the specified external workflow
 * execution and records a SignalExternalWorkflowExecutionInitiated event in the history.
 *
 *
 * StartChildWorkflowExecution – Requests that a child workflow execution be started and records a
 * StartChildWorkflowExecutionInitiated event in the history. The child workflow execution is a
 * separate workflow execution with its own history.
 *
 *
 * StartTimer – Starts a timer for this workflow execution and records a TimerStarted event in
 * the history. This timer fires after the specified delay and record a TimerFired event.
 *
 *
 * Access Control
 *
 * If you grant permission to use RespondDecisionTaskCompleted, you can use IAM policies to express
 * permissions for the list of decisions returned by this action as if they were members of the API. Treating
 * decisions as a pseudo API maintains a uniform conceptual model and helps keep policies readable. For details and
 * example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF
 * Workflows in the Amazon SWF Developer Guide.
 *
 *
 * Decision Failure
 *
 *
 * Decisions can fail for several reasons
 *
 *
 *
 * The ordering of decisions should follow a logical flow. Some decisions might not make sense in the current context of the workflow execution and therefore fails.
 *
 * A limit on your account was reached.
 *
 * The decision lacks sufficient permissions.
 *
 *
 *
 * One of the following events might be added to the history to indicate an error. The event attribute's
 * cause parameter indicates the cause. If cause is set to OPERATION_NOT_PERMITTED, the decision failed
 * because it lacked sufficient permissions. For details and example IAM policies, see <a href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to Amazon SWF Workflows
 * in the Amazon SWF Developer Guide.
 *
 *
 *
 *
 * ScheduleActivityTaskFailed – A ScheduleActivityTask decision failed. This could happen if the
 * activity type specified in the decision isn't registered, is in a deprecated state, or the decision isn't
 * properly configured.
 *
 *
 * RequestCancelActivityTaskFailed – A
 * RequestCancelActivityTask decision failed. This could happen if
 * there is no open activity task with the specified activityId.
 *
 *
 * StartTimerFailed – A StartTimer decision failed. This
 * could happen if there is another open timer with the same timerId.
 *
 *
 * CancelTimerFailed – A CancelTimer decision failed.
 * This could happen if there is no open timer with the specified
 * timerId.
 *
 *
 * StartChildWorkflowExecutionFailed – A
 * StartChildWorkflowExecution decision failed. This could happen
 * if the workflow type specified isn't registered, is deprecated, or the decision
 * isn't properly configured.
 *
 *
 * SignalExternalWorkflowExecutionFailed – A
 * SignalExternalWorkflowExecution decision failed. This could
 * happen if the workflowID specified in the decision was
 * incorrect.
 *
 *
 * RequestCancelExternalWorkflowExecutionFailed – A
 * RequestCancelExternalWorkflowExecution decision failed. This
 * could happen if the workflowID specified in the decision was
 * incorrect.
 *
 *
 * CancelWorkflowExecutionFailed – A
 * CancelWorkflowExecution decision failed. This could happen if
 * there is an unhandled decision task pending in the workflow execution.
 *
 *
 * CompleteWorkflowExecutionFailed – A
 * CompleteWorkflowExecution decision failed. This could happen if
 * there is an unhandled decision task pending in the workflow execution.
 *
 *
 * ContinueAsNewWorkflowExecutionFailed – A
 * ContinueAsNewWorkflowExecution decision failed. This could
 * happen if there is an unhandled decision task pending in the workflow execution
 * or the ContinueAsNewWorkflowExecution decision was not configured
 * correctly.
 *
 *
 * FailWorkflowExecutionFailed – A FailWorkflowExecution
 * decision failed. This could happen if there is an unhandled decision task
 * pending in the workflow execution.
 *
 *
 * The preceding error events might occur due to an error in the decider logic, which might put the workflow execution in an unstable state The cause field in the event structure for the error event indicates the cause of the error.
 *
 * A workflow execution may be closed by the decider by returning one of the following decisions when completing
 * a decision task: CompleteWorkflowExecution, FailWorkflowExecution,
 * CancelWorkflowExecution and ContinueAsNewWorkflowExecution. An UnhandledDecision fault
 * is returned if a workflow closing decision is specified and a signal or activity event had been added to the
 * history while the decision task was being performed by the decider. Unlike the above situations which are logic
 * issues, this fault is always possible because of race conditions in a distributed system. The right action here is
 * to call RespondDecisionTaskCompleted  without any decisions. This would result in another decision task
 * with these new events included in the history. The decider should handle the new events and may decide to close
 * the workflow execution.
 *
 * How to Code a Decision
 *
 * You code a decision by first setting the decision type field to one of the above decision values, and then set the corresponding attributes field shown below:
 *
 *
 *
 *
 * ScheduleActivityTaskDecisionAttributes
 *
 *
 *
 *
 *
 * RequestCancelActivityTaskDecisionAttributes
 *
 *
 *
 *
 *
 * CompleteWorkflowExecutionDecisionAttributes
 *
 *
 *
 *
 *
 * FailWorkflowExecutionDecisionAttributes
 *
 *
 *
 *
 *
 * CancelWorkflowExecutionDecisionAttributes
 *
 *
 *
 *
 *
 * ContinueAsNewWorkflowExecutionDecisionAttributes
 *
 *
 *
 *
 *
 * RecordMarkerDecisionAttributes
 *
 *
 *
 *
 *
 * StartTimerDecisionAttributes
 *
 *
 *
 *
 *
 * CancelTimerDecisionAttributes
 *
 *
 *
 *
 *
 * SignalExternalWorkflowExecutionDecisionAttributes
 *
 *
 *
 *
 *
 * RequestCancelExternalWorkflowExecutionDecisionAttributes
 *
 *
 *
 *
 *
 * StartChildWorkflowExecutionDecisionAttributes
 */
class Decision private constructor(builder: Builder) {
    /**
     * Provides the details of the CancelTimer decision. It isn't set for other decision types.
     */
    val cancelTimerDecisionAttributes: aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes? = builder.cancelTimerDecisionAttributes
    /**
     * Provides the details of the CancelWorkflowExecution decision. It isn't set for other decision types.
     */
    val cancelWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionDecisionAttributes? = builder.cancelWorkflowExecutionDecisionAttributes
    /**
     * Provides the details of the CompleteWorkflowExecution decision. It isn't set for other decision types.
     */
    val completeWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes? = builder.completeWorkflowExecutionDecisionAttributes
    /**
     * Provides the details of the ContinueAsNewWorkflowExecution decision. It isn't set for other decision types.
     */
    val continueAsNewWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes? = builder.continueAsNewWorkflowExecutionDecisionAttributes
    /**
     * Specifies the type of the decision.
     */
    val decisionType: aws.sdk.kotlin.services.swf.model.DecisionType? = builder.decisionType
    /**
     * Provides the details of the FailWorkflowExecution decision. It isn't set for other decision types.
     */
    val failWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes? = builder.failWorkflowExecutionDecisionAttributes
    /**
     * Provides the details of the RecordMarker decision. It isn't set for other decision types.
     */
    val recordMarkerDecisionAttributes: aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes? = builder.recordMarkerDecisionAttributes
    /**
     * Provides the details of the RequestCancelActivityTask decision. It isn't set for other decision types.
     */
    val requestCancelActivityTaskDecisionAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes? = builder.requestCancelActivityTaskDecisionAttributes
    /**
     * Provides the details of the RequestCancelExternalWorkflowExecution decision.
     * It isn't set for other decision types.
     */
    val requestCancelExternalWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes? = builder.requestCancelExternalWorkflowExecutionDecisionAttributes
    /**
     * Provides the details of the ScheduleActivityTask decision. It isn't set for other decision types.
     */
    val scheduleActivityTaskDecisionAttributes: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes? = builder.scheduleActivityTaskDecisionAttributes
    /**
     * Provides the details of the ScheduleLambdaFunction decision. It isn't set
     * for other decision types.
     */
    val scheduleLambdaFunctionDecisionAttributes: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionDecisionAttributes? = builder.scheduleLambdaFunctionDecisionAttributes
    /**
     * Provides the details of the SignalExternalWorkflowExecution decision. It isn't set for other decision types.
     */
    val signalExternalWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes? = builder.signalExternalWorkflowExecutionDecisionAttributes
    /**
     * Provides the details of the StartChildWorkflowExecution decision. It isn't set for other decision types.
     */
    val startChildWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes? = builder.startChildWorkflowExecutionDecisionAttributes
    /**
     * Provides the details of the StartTimer decision. It isn't set for other decision types.
     */
    val startTimerDecisionAttributes: aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes? = builder.startTimerDecisionAttributes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.Decision = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Decision(")
        append("cancelTimerDecisionAttributes=$cancelTimerDecisionAttributes,")
        append("cancelWorkflowExecutionDecisionAttributes=$cancelWorkflowExecutionDecisionAttributes,")
        append("completeWorkflowExecutionDecisionAttributes=$completeWorkflowExecutionDecisionAttributes,")
        append("continueAsNewWorkflowExecutionDecisionAttributes=$continueAsNewWorkflowExecutionDecisionAttributes,")
        append("decisionType=$decisionType,")
        append("failWorkflowExecutionDecisionAttributes=$failWorkflowExecutionDecisionAttributes,")
        append("recordMarkerDecisionAttributes=$recordMarkerDecisionAttributes,")
        append("requestCancelActivityTaskDecisionAttributes=$requestCancelActivityTaskDecisionAttributes,")
        append("requestCancelExternalWorkflowExecutionDecisionAttributes=$requestCancelExternalWorkflowExecutionDecisionAttributes,")
        append("scheduleActivityTaskDecisionAttributes=$scheduleActivityTaskDecisionAttributes,")
        append("scheduleLambdaFunctionDecisionAttributes=$scheduleLambdaFunctionDecisionAttributes,")
        append("signalExternalWorkflowExecutionDecisionAttributes=$signalExternalWorkflowExecutionDecisionAttributes,")
        append("startChildWorkflowExecutionDecisionAttributes=$startChildWorkflowExecutionDecisionAttributes,")
        append("startTimerDecisionAttributes=$startTimerDecisionAttributes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cancelTimerDecisionAttributes?.hashCode() ?: 0
        result = 31 * result + (cancelWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (completeWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (continueAsNewWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (decisionType?.hashCode() ?: 0)
        result = 31 * result + (failWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (recordMarkerDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (requestCancelActivityTaskDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (requestCancelExternalWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (scheduleActivityTaskDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (scheduleLambdaFunctionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (signalExternalWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (startChildWorkflowExecutionDecisionAttributes?.hashCode() ?: 0)
        result = 31 * result + (startTimerDecisionAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Decision

        if (cancelTimerDecisionAttributes != other.cancelTimerDecisionAttributes) return false
        if (cancelWorkflowExecutionDecisionAttributes != other.cancelWorkflowExecutionDecisionAttributes) return false
        if (completeWorkflowExecutionDecisionAttributes != other.completeWorkflowExecutionDecisionAttributes) return false
        if (continueAsNewWorkflowExecutionDecisionAttributes != other.continueAsNewWorkflowExecutionDecisionAttributes) return false
        if (decisionType != other.decisionType) return false
        if (failWorkflowExecutionDecisionAttributes != other.failWorkflowExecutionDecisionAttributes) return false
        if (recordMarkerDecisionAttributes != other.recordMarkerDecisionAttributes) return false
        if (requestCancelActivityTaskDecisionAttributes != other.requestCancelActivityTaskDecisionAttributes) return false
        if (requestCancelExternalWorkflowExecutionDecisionAttributes != other.requestCancelExternalWorkflowExecutionDecisionAttributes) return false
        if (scheduleActivityTaskDecisionAttributes != other.scheduleActivityTaskDecisionAttributes) return false
        if (scheduleLambdaFunctionDecisionAttributes != other.scheduleLambdaFunctionDecisionAttributes) return false
        if (signalExternalWorkflowExecutionDecisionAttributes != other.signalExternalWorkflowExecutionDecisionAttributes) return false
        if (startChildWorkflowExecutionDecisionAttributes != other.startChildWorkflowExecutionDecisionAttributes) return false
        if (startTimerDecisionAttributes != other.startTimerDecisionAttributes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.Decision = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides the details of the CancelTimer decision. It isn't set for other decision types.
         */
        var cancelTimerDecisionAttributes: aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes? = null
        /**
         * Provides the details of the CancelWorkflowExecution decision. It isn't set for other decision types.
         */
        var cancelWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionDecisionAttributes? = null
        /**
         * Provides the details of the CompleteWorkflowExecution decision. It isn't set for other decision types.
         */
        var completeWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes? = null
        /**
         * Provides the details of the ContinueAsNewWorkflowExecution decision. It isn't set for other decision types.
         */
        var continueAsNewWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes? = null
        /**
         * Specifies the type of the decision.
         */
        var decisionType: aws.sdk.kotlin.services.swf.model.DecisionType? = null
        /**
         * Provides the details of the FailWorkflowExecution decision. It isn't set for other decision types.
         */
        var failWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes? = null
        /**
         * Provides the details of the RecordMarker decision. It isn't set for other decision types.
         */
        var recordMarkerDecisionAttributes: aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes? = null
        /**
         * Provides the details of the RequestCancelActivityTask decision. It isn't set for other decision types.
         */
        var requestCancelActivityTaskDecisionAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes? = null
        /**
         * Provides the details of the RequestCancelExternalWorkflowExecution decision.
         * It isn't set for other decision types.
         */
        var requestCancelExternalWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes? = null
        /**
         * Provides the details of the ScheduleActivityTask decision. It isn't set for other decision types.
         */
        var scheduleActivityTaskDecisionAttributes: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes? = null
        /**
         * Provides the details of the ScheduleLambdaFunction decision. It isn't set
         * for other decision types.
         */
        var scheduleLambdaFunctionDecisionAttributes: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionDecisionAttributes? = null
        /**
         * Provides the details of the SignalExternalWorkflowExecution decision. It isn't set for other decision types.
         */
        var signalExternalWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes? = null
        /**
         * Provides the details of the StartChildWorkflowExecution decision. It isn't set for other decision types.
         */
        var startChildWorkflowExecutionDecisionAttributes: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes? = null
        /**
         * Provides the details of the StartTimer decision. It isn't set for other decision types.
         */
        var startTimerDecisionAttributes: aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.Decision) : this() {
            this.cancelTimerDecisionAttributes = x.cancelTimerDecisionAttributes
            this.cancelWorkflowExecutionDecisionAttributes = x.cancelWorkflowExecutionDecisionAttributes
            this.completeWorkflowExecutionDecisionAttributes = x.completeWorkflowExecutionDecisionAttributes
            this.continueAsNewWorkflowExecutionDecisionAttributes = x.continueAsNewWorkflowExecutionDecisionAttributes
            this.decisionType = x.decisionType
            this.failWorkflowExecutionDecisionAttributes = x.failWorkflowExecutionDecisionAttributes
            this.recordMarkerDecisionAttributes = x.recordMarkerDecisionAttributes
            this.requestCancelActivityTaskDecisionAttributes = x.requestCancelActivityTaskDecisionAttributes
            this.requestCancelExternalWorkflowExecutionDecisionAttributes = x.requestCancelExternalWorkflowExecutionDecisionAttributes
            this.scheduleActivityTaskDecisionAttributes = x.scheduleActivityTaskDecisionAttributes
            this.scheduleLambdaFunctionDecisionAttributes = x.scheduleLambdaFunctionDecisionAttributes
            this.signalExternalWorkflowExecutionDecisionAttributes = x.signalExternalWorkflowExecutionDecisionAttributes
            this.startChildWorkflowExecutionDecisionAttributes = x.startChildWorkflowExecutionDecisionAttributes
            this.startTimerDecisionAttributes = x.startTimerDecisionAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.Decision = Decision(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes] inside the given [block]
         */
        fun cancelTimerDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.cancelTimerDecisionAttributes = aws.sdk.kotlin.services.swf.model.CancelTimerDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun cancelWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.cancelWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun completeWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.completeWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun continueAsNewWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.continueAsNewWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun failWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.failWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes] inside the given [block]
         */
        fun recordMarkerDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.recordMarkerDecisionAttributes = aws.sdk.kotlin.services.swf.model.RecordMarkerDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes] inside the given [block]
         */
        fun requestCancelActivityTaskDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.requestCancelActivityTaskDecisionAttributes = aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun requestCancelExternalWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.requestCancelExternalWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes] inside the given [block]
         */
        fun scheduleActivityTaskDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.scheduleActivityTaskDecisionAttributes = aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionDecisionAttributes] inside the given [block]
         */
        fun scheduleLambdaFunctionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.scheduleLambdaFunctionDecisionAttributes = aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun signalExternalWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.signalExternalWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes] inside the given [block]
         */
        fun startChildWorkflowExecutionDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.startChildWorkflowExecutionDecisionAttributes = aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes] inside the given [block]
         */
        fun startTimerDecisionAttributes(block: aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes.Builder.() -> kotlin.Unit) {
            this.startTimerDecisionAttributes = aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes.invoke(block)
        }
    }
}
