// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the DecisionTaskTimedOut event.
 */
class DecisionTaskTimedOutEventAttributes private constructor(builder: Builder) {
    /**
     * The ID of the DecisionTaskScheduled event that was recorded when this decision task was scheduled.
     * This information can be useful for diagnosing problems by tracing back the chain of
     * events leading up to this event.
     */
    val scheduledEventId: kotlin.Long = builder.scheduledEventId
    /**
     * The ID of the DecisionTaskStarted event recorded when this decision task was started. This
     * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     * event.
     */
    val startedEventId: kotlin.Long = builder.startedEventId
    /**
     * The type of timeout that expired before the decision task could be completed.
     */
    val timeoutType: aws.sdk.kotlin.services.swf.model.DecisionTaskTimeoutType? = builder.timeoutType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DecisionTaskTimedOutEventAttributes(")
        append("scheduledEventId=$scheduledEventId,")
        append("startedEventId=$startedEventId,")
        append("timeoutType=$timeoutType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = scheduledEventId.hashCode()
        result = 31 * result + (startedEventId.hashCode())
        result = 31 * result + (timeoutType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DecisionTaskTimedOutEventAttributes

        if (scheduledEventId != other.scheduledEventId) return false
        if (startedEventId != other.startedEventId) return false
        if (timeoutType != other.timeoutType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the DecisionTaskScheduled event that was recorded when this decision task was scheduled.
         * This information can be useful for diagnosing problems by tracing back the chain of
         * events leading up to this event.
         */
        var scheduledEventId: kotlin.Long = 0L
        /**
         * The ID of the DecisionTaskStarted event recorded when this decision task was started. This
         * information can be useful for diagnosing problems by tracing back the chain of events leading up to this
         * event.
         */
        var startedEventId: kotlin.Long = 0L
        /**
         * The type of timeout that expired before the decision task could be completed.
         */
        var timeoutType: aws.sdk.kotlin.services.swf.model.DecisionTaskTimeoutType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes) : this() {
            this.scheduledEventId = x.scheduledEventId
            this.startedEventId = x.startedEventId
            this.timeoutType = x.timeoutType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes = DecisionTaskTimedOutEventAttributes(this)
    }
}
