// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



class ListOpenWorkflowExecutionsRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the workflow executions to list.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * If specified, only workflow executions matching the workflow ID specified in the filter
     * are returned.
     *
     *
     * executionFilter, typeFilter and tagFilter are
     * mutually exclusive. You can specify at most one of these in a request.
     */
    val executionFilter: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter? = builder.executionFilter
    /**
     * The maximum number of results that are returned per call.
     * Use nextPageToken to obtain further pages of results.
     */
    val maximumPageSize: kotlin.Int = builder.maximumPageSize
    /**
     * If NextPageToken is returned there are more results
     * available.  The value of NextPageToken is a unique pagination token for each page. Make the call again using
     * the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
     * after 60 seconds. Using an expired pagination token will return a 400 error: "Specified token has
     * exceeded its maximum lifetime".
     *
     * The configured maximumPageSize determines how many results can be returned
     * in a single call.
     */
    val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * When set to true, returns the results in reverse order. By default the
     * results are returned in descending order of the start time of the executions.
     */
    val reverseOrder: kotlin.Boolean = builder.reverseOrder
    /**
     * Workflow executions are included in the returned results based on whether their start
     * times are within the range specified by this filter.
     */
    val startTimeFilter: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter? = builder.startTimeFilter
    /**
     * If specified, only executions that have the matching tag are listed.
     *
     *
     * executionFilter, typeFilter and tagFilter are
     * mutually exclusive. You can specify at most one of these in a request.
     */
    val tagFilter: aws.sdk.kotlin.services.swf.model.TagFilter? = builder.tagFilter
    /**
     * If specified, only executions of the type specified in the filter are
     * returned.
     *
     *
     * executionFilter, typeFilter and tagFilter are
     * mutually exclusive. You can specify at most one of these in a request.
     */
    val typeFilter: aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter? = builder.typeFilter

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListOpenWorkflowExecutionsRequest(")
        append("domain=$domain,")
        append("executionFilter=$executionFilter,")
        append("maximumPageSize=$maximumPageSize,")
        append("nextPageToken=$nextPageToken,")
        append("reverseOrder=$reverseOrder,")
        append("startTimeFilter=$startTimeFilter,")
        append("tagFilter=$tagFilter,")
        append("typeFilter=$typeFilter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (executionFilter?.hashCode() ?: 0)
        result = 31 * result + (maximumPageSize)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (reverseOrder.hashCode())
        result = 31 * result + (startTimeFilter?.hashCode() ?: 0)
        result = 31 * result + (tagFilter?.hashCode() ?: 0)
        result = 31 * result + (typeFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListOpenWorkflowExecutionsRequest

        if (domain != other.domain) return false
        if (executionFilter != other.executionFilter) return false
        if (maximumPageSize != other.maximumPageSize) return false
        if (nextPageToken != other.nextPageToken) return false
        if (reverseOrder != other.reverseOrder) return false
        if (startTimeFilter != other.startTimeFilter) return false
        if (tagFilter != other.tagFilter) return false
        if (typeFilter != other.typeFilter) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the domain that contains the workflow executions to list.
         */
        var domain: kotlin.String? = null
        /**
         * If specified, only workflow executions matching the workflow ID specified in the filter
         * are returned.
         *
         *
         * executionFilter, typeFilter and tagFilter are
         * mutually exclusive. You can specify at most one of these in a request.
         */
        var executionFilter: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter? = null
        /**
         * The maximum number of results that are returned per call.
         * Use nextPageToken to obtain further pages of results.
         */
        var maximumPageSize: kotlin.Int = 0
        /**
         * If NextPageToken is returned there are more results
         * available.  The value of NextPageToken is a unique pagination token for each page. Make the call again using
         * the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires
         * after 60 seconds. Using an expired pagination token will return a 400 error: "Specified token has
         * exceeded its maximum lifetime".
         *
         * The configured maximumPageSize determines how many results can be returned
         * in a single call.
         */
        var nextPageToken: kotlin.String? = null
        /**
         * When set to true, returns the results in reverse order. By default the
         * results are returned in descending order of the start time of the executions.
         */
        var reverseOrder: kotlin.Boolean = false
        /**
         * Workflow executions are included in the returned results based on whether their start
         * times are within the range specified by this filter.
         */
        var startTimeFilter: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter? = null
        /**
         * If specified, only executions that have the matching tag are listed.
         *
         *
         * executionFilter, typeFilter and tagFilter are
         * mutually exclusive. You can specify at most one of these in a request.
         */
        var tagFilter: aws.sdk.kotlin.services.swf.model.TagFilter? = null
        /**
         * If specified, only executions of the type specified in the filter are
         * returned.
         *
         *
         * executionFilter, typeFilter and tagFilter are
         * mutually exclusive. You can specify at most one of these in a request.
         */
        var typeFilter: aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest) : this() {
            this.domain = x.domain
            this.executionFilter = x.executionFilter
            this.maximumPageSize = x.maximumPageSize
            this.nextPageToken = x.nextPageToken
            this.reverseOrder = x.reverseOrder
            this.startTimeFilter = x.startTimeFilter
            this.tagFilter = x.tagFilter
            this.typeFilter = x.typeFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest = ListOpenWorkflowExecutionsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter] inside the given [block]
         */
        fun executionFilter(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter.Builder.() -> kotlin.Unit) {
            this.executionFilter = aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter] inside the given [block]
         */
        fun startTimeFilter(block: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter.Builder.() -> kotlin.Unit) {
            this.startTimeFilter = aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TagFilter] inside the given [block]
         */
        fun tagFilter(block: aws.sdk.kotlin.services.swf.model.TagFilter.Builder.() -> kotlin.Unit) {
            this.tagFilter = aws.sdk.kotlin.services.swf.model.TagFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter] inside the given [block]
         */
        fun typeFilter(block: aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter.Builder.() -> kotlin.Unit) {
            this.typeFilter = aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter.invoke(block)
        }
    }
}
