// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a workflow execution.
 */
class WorkflowExecutionInfo private constructor(builder: Builder) {
    /**
     * Set to true if a cancellation is requested for this workflow execution.
     */
    val cancelRequested: kotlin.Boolean = builder.cancelRequested
    /**
     * If the execution status is closed then this specifies how the execution was closed:
     *
     *
     *
     * COMPLETED – the execution was successfully completed.
     *
     *
     * CANCELED – the execution was canceled.Cancellation allows the implementation to gracefully clean
     * up before the execution is closed.
     *
     *
     * TERMINATED – the execution was force terminated.
     *
     *
     * FAILED – the execution failed to complete.
     *
     *
     * TIMED_OUT – the execution did not complete in the alloted time and was automatically timed
     * out.
     *
     *
     * CONTINUED_AS_NEW – the execution is logically continued. This means the current execution was
     * completed and a new execution was started to carry on the workflow.
     */
    val closeStatus: aws.sdk.kotlin.services.swf.model.CloseStatus? = builder.closeStatus
    /**
     * The time when the workflow execution was closed. Set only if the execution status is CLOSED.
     */
    val closeTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.closeTimestamp
    /**
     * The workflow execution this information is about.
     */
    val execution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = builder.execution
    /**
     * The current status of the execution.
     */
    val executionStatus: aws.sdk.kotlin.services.swf.model.ExecutionStatus? = builder.executionStatus
    /**
     * If this workflow execution is a child of another execution then contains the workflow execution that started this execution.
     */
    val parent: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = builder.parent
    /**
     * The time when the execution was started.
     */
    val startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimestamp
    /**
     * The list of tags associated with the workflow execution. Tags can be used to identify and list workflow executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.
     */
    val tagList: List<String>? = builder.tagList
    /**
     * The type of the workflow execution.
     */
    val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowExecutionInfo(")
        append("cancelRequested=$cancelRequested,")
        append("closeStatus=$closeStatus,")
        append("closeTimestamp=$closeTimestamp,")
        append("execution=$execution,")
        append("executionStatus=$executionStatus,")
        append("parent=$parent,")
        append("startTimestamp=$startTimestamp,")
        append("tagList=$tagList,")
        append("workflowType=$workflowType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cancelRequested.hashCode()
        result = 31 * result + (closeStatus?.hashCode() ?: 0)
        result = 31 * result + (closeTimestamp?.hashCode() ?: 0)
        result = 31 * result + (execution?.hashCode() ?: 0)
        result = 31 * result + (executionStatus?.hashCode() ?: 0)
        result = 31 * result + (parent?.hashCode() ?: 0)
        result = 31 * result + (startTimestamp?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowExecutionInfo

        if (cancelRequested != other.cancelRequested) return false
        if (closeStatus != other.closeStatus) return false
        if (closeTimestamp != other.closeTimestamp) return false
        if (execution != other.execution) return false
        if (executionStatus != other.executionStatus) return false
        if (parent != other.parent) return false
        if (startTimestamp != other.startTimestamp) return false
        if (tagList != other.tagList) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set to true if a cancellation is requested for this workflow execution.
         */
        var cancelRequested: kotlin.Boolean = false
        /**
         * If the execution status is closed then this specifies how the execution was closed:
         *
         *
         *
         * COMPLETED – the execution was successfully completed.
         *
         *
         * CANCELED – the execution was canceled.Cancellation allows the implementation to gracefully clean
         * up before the execution is closed.
         *
         *
         * TERMINATED – the execution was force terminated.
         *
         *
         * FAILED – the execution failed to complete.
         *
         *
         * TIMED_OUT – the execution did not complete in the alloted time and was automatically timed
         * out.
         *
         *
         * CONTINUED_AS_NEW – the execution is logically continued. This means the current execution was
         * completed and a new execution was started to carry on the workflow.
         */
        var closeStatus: aws.sdk.kotlin.services.swf.model.CloseStatus? = null
        /**
         * The time when the workflow execution was closed. Set only if the execution status is CLOSED.
         */
        var closeTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The workflow execution this information is about.
         */
        var execution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = null
        /**
         * The current status of the execution.
         */
        var executionStatus: aws.sdk.kotlin.services.swf.model.ExecutionStatus? = null
        /**
         * If this workflow execution is a child of another execution then contains the workflow execution that started this execution.
         */
        var parent: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = null
        /**
         * The time when the execution was started.
         */
        var startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of tags associated with the workflow execution. Tags can be used to identify and list workflow executions of interest through the visibility APIs. A workflow execution can have a maximum of 5 tags.
         */
        var tagList: List<String>? = null
        /**
         * The type of the workflow execution.
         */
        var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo) : this() {
            this.cancelRequested = x.cancelRequested
            this.closeStatus = x.closeStatus
            this.closeTimestamp = x.closeTimestamp
            this.execution = x.execution
            this.executionStatus = x.executionStatus
            this.parent = x.parent
            this.startTimestamp = x.startTimestamp
            this.tagList = x.tagList
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo = WorkflowExecutionInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecution] inside the given [block]
         */
        fun execution(block: aws.sdk.kotlin.services.swf.model.WorkflowExecution.Builder.() -> kotlin.Unit) {
            this.execution = aws.sdk.kotlin.services.swf.model.WorkflowExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecution] inside the given [block]
         */
        fun parent(block: aws.sdk.kotlin.services.swf.model.WorkflowExecution.Builder.() -> kotlin.Unit) {
            this.parent = aws.sdk.kotlin.services.swf.model.WorkflowExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }
    }
}
