// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter
import aws.sdk.kotlin.services.swf.model.ListOpenWorkflowExecutionsRequest
import aws.sdk.kotlin.services.swf.model.TagFilter
import aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter
import aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListOpenWorkflowExecutionsOperationSerializer: HttpSerialize<ListOpenWorkflowExecutionsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListOpenWorkflowExecutionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeListOpenWorkflowExecutionsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        return builder
    }
}

private fun serializeListOpenWorkflowExecutionsOperationBody(context: ExecutionContext, input: ListOpenWorkflowExecutionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domain"))
    val EXECUTIONFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("executionFilter"))
    val MAXIMUMPAGESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maximumPageSize"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextPageToken"))
    val REVERSEORDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("reverseOrder"))
    val STARTTIMEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("startTimeFilter"))
    val TAGFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tagFilter"))
    val TYPEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("typeFilter"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAIN_DESCRIPTOR)
        field(EXECUTIONFILTER_DESCRIPTOR)
        field(MAXIMUMPAGESIZE_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(REVERSEORDER_DESCRIPTOR)
        field(STARTTIMEFILTER_DESCRIPTOR)
        field(TAGFILTER_DESCRIPTOR)
        field(TYPEFILTER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.domain?.let { field(DOMAIN_DESCRIPTOR, it) }
        input.executionFilter?.let { field(EXECUTIONFILTER_DESCRIPTOR, it, ::serializeWorkflowExecutionFilterDocument) }
        if (input.maximumPageSize != 0) field(MAXIMUMPAGESIZE_DESCRIPTOR, input.maximumPageSize)
        input.nextPageToken?.let { field(NEXTPAGETOKEN_DESCRIPTOR, it) }
        if (input.reverseOrder != false) field(REVERSEORDER_DESCRIPTOR, input.reverseOrder)
        input.startTimeFilter?.let { field(STARTTIMEFILTER_DESCRIPTOR, it, ::serializeExecutionTimeFilterDocument) }
        input.tagFilter?.let { field(TAGFILTER_DESCRIPTOR, it, ::serializeTagFilterDocument) }
        input.typeFilter?.let { field(TYPEFILTER_DESCRIPTOR, it, ::serializeWorkflowTypeFilterDocument) }
    }
    return serializer.toByteArray()
}
