// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Configuration settings registered with the activity type.
 */
class ActivityTypeConfiguration private constructor(builder: Builder) {
    /**
     * The default maximum time, in seconds, before which a worker processing a task must report progress by calling RecordActivityTaskHeartbeat.
     *
     * You can specify this value only when *registering* an activity type. The registered default value can be overridden when you schedule a task through the `ScheduleActivityTask`Decision. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an `UnknownResource` fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val defaultTaskHeartbeatTimeout: kotlin.String? = builder.defaultTaskHeartbeatTimeout
    /**
     * The default task list specified for this activity type at registration. This default is used if a task list isn't provided when a task is scheduled through the `ScheduleActivityTask`Decision. You can override the default registered task list when scheduling a task through the `ScheduleActivityTask`Decision.
     */
    val defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.defaultTaskList
    /**
     * The default task priority for tasks of this activity type, specified at registration. If not set, then `0` is used as the default priority. This default can be overridden when scheduling an activity task.
     *
     * Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    val defaultTaskPriority: kotlin.String? = builder.defaultTaskPriority
    /**
     * The default maximum duration, specified when registering the activity type, for tasks of this activity type. You can override this default when scheduling a task through the `ScheduleActivityTask`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val defaultTaskScheduleToCloseTimeout: kotlin.String? = builder.defaultTaskScheduleToCloseTimeout
    /**
     * The default maximum duration, specified when registering the activity type, that a task of an activity type can wait before being assigned to a worker. You can override this default when scheduling a task through the `ScheduleActivityTask`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val defaultTaskScheduleToStartTimeout: kotlin.String? = builder.defaultTaskScheduleToStartTimeout
    /**
     * The default maximum duration for tasks of an activity type specified when registering the activity type. You can override this default when scheduling a task through the `ScheduleActivityTask`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val defaultTaskStartToCloseTimeout: kotlin.String? = builder.defaultTaskStartToCloseTimeout

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ActivityTypeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivityTypeConfiguration(")
        append("defaultTaskHeartbeatTimeout=$defaultTaskHeartbeatTimeout,")
        append("defaultTaskList=$defaultTaskList,")
        append("defaultTaskPriority=$defaultTaskPriority,")
        append("defaultTaskScheduleToCloseTimeout=$defaultTaskScheduleToCloseTimeout,")
        append("defaultTaskScheduleToStartTimeout=$defaultTaskScheduleToStartTimeout,")
        append("defaultTaskStartToCloseTimeout=$defaultTaskStartToCloseTimeout)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultTaskHeartbeatTimeout?.hashCode() ?: 0
        result = 31 * result + (defaultTaskList?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskPriority?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskScheduleToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskScheduleToStartTimeout?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskStartToCloseTimeout?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivityTypeConfiguration

        if (defaultTaskHeartbeatTimeout != other.defaultTaskHeartbeatTimeout) return false
        if (defaultTaskList != other.defaultTaskList) return false
        if (defaultTaskPriority != other.defaultTaskPriority) return false
        if (defaultTaskScheduleToCloseTimeout != other.defaultTaskScheduleToCloseTimeout) return false
        if (defaultTaskScheduleToStartTimeout != other.defaultTaskScheduleToStartTimeout) return false
        if (defaultTaskStartToCloseTimeout != other.defaultTaskStartToCloseTimeout) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ActivityTypeConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default maximum time, in seconds, before which a worker processing a task must report progress by calling RecordActivityTaskHeartbeat.
         *
         * You can specify this value only when *registering* an activity type. The registered default value can be overridden when you schedule a task through the `ScheduleActivityTask`Decision. If the activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an `UnknownResource` fault. In this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the activity task.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var defaultTaskHeartbeatTimeout: kotlin.String? = null
        /**
         * The default task list specified for this activity type at registration. This default is used if a task list isn't provided when a task is scheduled through the `ScheduleActivityTask`Decision. You can override the default registered task list when scheduling a task through the `ScheduleActivityTask`Decision.
         */
        var defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The default task priority for tasks of this activity type, specified at registration. If not set, then `0` is used as the default priority. This default can be overridden when scheduling an activity task.
         *
         * Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        var defaultTaskPriority: kotlin.String? = null
        /**
         * The default maximum duration, specified when registering the activity type, for tasks of this activity type. You can override this default when scheduling a task through the `ScheduleActivityTask`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var defaultTaskScheduleToCloseTimeout: kotlin.String? = null
        /**
         * The default maximum duration, specified when registering the activity type, that a task of an activity type can wait before being assigned to a worker. You can override this default when scheduling a task through the `ScheduleActivityTask`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var defaultTaskScheduleToStartTimeout: kotlin.String? = null
        /**
         * The default maximum duration for tasks of an activity type specified when registering the activity type. You can override this default when scheduling a task through the `ScheduleActivityTask`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var defaultTaskStartToCloseTimeout: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ActivityTypeConfiguration) : this() {
            this.defaultTaskHeartbeatTimeout = x.defaultTaskHeartbeatTimeout
            this.defaultTaskList = x.defaultTaskList
            this.defaultTaskPriority = x.defaultTaskPriority
            this.defaultTaskScheduleToCloseTimeout = x.defaultTaskScheduleToCloseTimeout
            this.defaultTaskScheduleToStartTimeout = x.defaultTaskScheduleToStartTimeout
            this.defaultTaskStartToCloseTimeout = x.defaultTaskStartToCloseTimeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ActivityTypeConfiguration = ActivityTypeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun defaultTaskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.defaultTaskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
