// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `ChildWorkflowExecutionTimedOut` event.
 */
class ChildWorkflowExecutionTimedOutEventAttributes private constructor(builder: Builder) {
    /**
     * The ID of the `StartChildWorkflowExecutionInitiated` event corresponding to the `StartChildWorkflowExecution`Decision to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    val initiatedEventId: kotlin.Long = builder.initiatedEventId
    /**
     * The ID of the `ChildWorkflowExecutionStarted` event recorded when this child workflow execution was started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    val startedEventId: kotlin.Long = builder.startedEventId
    /**
     * The type of the timeout that caused the child workflow execution to time out.
     */
    val timeoutType: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimeoutType? = builder.timeoutType
    /**
     * The child workflow execution that timed out.
     */
    val workflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = builder.workflowExecution
    /**
     * The type of the child workflow execution.
     */
    val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChildWorkflowExecutionTimedOutEventAttributes(")
        append("initiatedEventId=$initiatedEventId,")
        append("startedEventId=$startedEventId,")
        append("timeoutType=$timeoutType,")
        append("workflowExecution=$workflowExecution,")
        append("workflowType=$workflowType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = initiatedEventId.hashCode()
        result = 31 * result + (startedEventId.hashCode())
        result = 31 * result + (timeoutType?.hashCode() ?: 0)
        result = 31 * result + (workflowExecution?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChildWorkflowExecutionTimedOutEventAttributes

        if (initiatedEventId != other.initiatedEventId) return false
        if (startedEventId != other.startedEventId) return false
        if (timeoutType != other.timeoutType) return false
        if (workflowExecution != other.workflowExecution) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the `StartChildWorkflowExecutionInitiated` event corresponding to the `StartChildWorkflowExecution`Decision to start this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        var initiatedEventId: kotlin.Long = 0L
        /**
         * The ID of the `ChildWorkflowExecutionStarted` event recorded when this child workflow execution was started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        var startedEventId: kotlin.Long = 0L
        /**
         * The type of the timeout that caused the child workflow execution to time out.
         */
        var timeoutType: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimeoutType? = null
        /**
         * The child workflow execution that timed out.
         */
        var workflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = null
        /**
         * The type of the child workflow execution.
         */
        var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes) : this() {
            this.initiatedEventId = x.initiatedEventId
            this.startedEventId = x.startedEventId
            this.timeoutType = x.timeoutType
            this.workflowExecution = x.workflowExecution
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes = ChildWorkflowExecutionTimedOutEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecution] inside the given [block]
         */
        fun workflowExecution(block: aws.sdk.kotlin.services.swf.model.WorkflowExecution.Builder.() -> kotlin.Unit) {
            this.workflowExecution = aws.sdk.kotlin.services.swf.model.WorkflowExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }
    }
}
