// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides details about the `DecisionTaskScheduled` event.
 */
class DecisionTaskScheduledEventAttributes private constructor(builder: Builder) {
    /**
     * The maximum duration for this decision task. The task is considered timed out if it doesn't completed within this duration.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val startToCloseTimeout: kotlin.String? = builder.startToCloseTimeout
    /**
     * The name of the task list in which the decision task was scheduled.
     */
    val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * A task priority that, if set, specifies the priority for this decision task. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    val taskPriority: kotlin.String? = builder.taskPriority

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DecisionTaskScheduledEventAttributes(")
        append("startToCloseTimeout=$startToCloseTimeout,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority)")
    }

    override fun hashCode(): kotlin.Int {
        var result = startToCloseTimeout?.hashCode() ?: 0
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DecisionTaskScheduledEventAttributes

        if (startToCloseTimeout != other.startToCloseTimeout) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum duration for this decision task. The task is considered timed out if it doesn't completed within this duration.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var startToCloseTimeout: kotlin.String? = null
        /**
         * The name of the task list in which the decision task was scheduled.
         */
        var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * A task priority that, if set, specifies the priority for this decision task. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        var taskPriority: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes) : this() {
            this.startToCloseTimeout = x.startToCloseTimeout
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes = DecisionTaskScheduledEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
