// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



class ListDomainsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results that are returned per call. Use `nextPageToken` to obtain further pages of results.
     */
    val maximumPageSize: kotlin.Int = builder.maximumPageSize
    /**
     * If `NextPageToken` is returned there are more results available. The value of `NextPageToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a `400` error: "`Specified token has exceeded its maximum lifetime`".
     *
     * The configured `maximumPageSize` determines how many results can be returned in a single call.
     */
    val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * Specifies the registration status of the domains to list.
     */
    val registrationStatus: aws.sdk.kotlin.services.swf.model.RegistrationStatus? = builder.registrationStatus
    /**
     * When set to `true`, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by `name` of the domains.
     */
    val reverseOrder: kotlin.Boolean = builder.reverseOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ListDomainsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDomainsRequest(")
        append("maximumPageSize=$maximumPageSize,")
        append("nextPageToken=$nextPageToken,")
        append("registrationStatus=$registrationStatus,")
        append("reverseOrder=$reverseOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maximumPageSize
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (registrationStatus?.hashCode() ?: 0)
        result = 31 * result + (reverseOrder.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDomainsRequest

        if (maximumPageSize != other.maximumPageSize) return false
        if (nextPageToken != other.nextPageToken) return false
        if (registrationStatus != other.registrationStatus) return false
        if (reverseOrder != other.reverseOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ListDomainsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of results that are returned per call. Use `nextPageToken` to obtain further pages of results.
         */
        var maximumPageSize: kotlin.Int = 0
        /**
         * If `NextPageToken` is returned there are more results available. The value of `NextPageToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a `400` error: "`Specified token has exceeded its maximum lifetime`".
         *
         * The configured `maximumPageSize` determines how many results can be returned in a single call.
         */
        var nextPageToken: kotlin.String? = null
        /**
         * Specifies the registration status of the domains to list.
         */
        var registrationStatus: aws.sdk.kotlin.services.swf.model.RegistrationStatus? = null
        /**
         * When set to `true`, returns the results in reverse order. By default, the results are returned in ascending alphabetical order by `name` of the domains.
         */
        var reverseOrder: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ListDomainsRequest) : this() {
            this.maximumPageSize = x.maximumPageSize
            this.nextPageToken = x.nextPageToken
            this.registrationStatus = x.registrationStatus
            this.reverseOrder = x.reverseOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ListDomainsRequest = ListDomainsRequest(this)
    }
}
