// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



class PollForDecisionTaskRequest private constructor(builder: Builder) {
    /**
     * The name of the domain containing the task lists to poll.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.
     */
    val identity: kotlin.String? = builder.identity
    /**
     * The maximum number of results that are returned per call. Use `nextPageToken` to obtain further pages of results.
     *
     * This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.
     */
    val maximumPageSize: kotlin.Int = builder.maximumPageSize
    /**
     * If `NextPageToken` is returned there are more results available. The value of `NextPageToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a `400` error: "`Specified token has exceeded its maximum lifetime`".
     *
     * The configured `maximumPageSize` determines how many results can be returned in a single call.
     *
     * The `nextPageToken` returned by this action cannot be used with GetWorkflowExecutionHistory to get the next page. You must call PollForDecisionTask again (with the `nextPageToken`) to retrieve the next page of history records. Calling PollForDecisionTask with a `nextPageToken` doesn't return a new decision task.
     */
    val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * When set to `true`, returns the events in reverse order. By default the results are returned in ascending order of the `eventTimestamp` of the events.
     */
    val reverseOrder: kotlin.Boolean = builder.reverseOrder
    /**
     * Specifies the task list to poll for decision tasks.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
     */
    val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.PollForDecisionTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PollForDecisionTaskRequest(")
        append("domain=$domain,")
        append("identity=$identity,")
        append("maximumPageSize=$maximumPageSize,")
        append("nextPageToken=$nextPageToken,")
        append("reverseOrder=$reverseOrder,")
        append("taskList=$taskList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (maximumPageSize)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (reverseOrder.hashCode())
        result = 31 * result + (taskList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PollForDecisionTaskRequest

        if (domain != other.domain) return false
        if (identity != other.identity) return false
        if (maximumPageSize != other.maximumPageSize) return false
        if (nextPageToken != other.nextPageToken) return false
        if (reverseOrder != other.reverseOrder) return false
        if (taskList != other.taskList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.PollForDecisionTaskRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the domain containing the task lists to poll.
         */
        var domain: kotlin.String? = null
        /**
         * Identity of the decider making the request, which is recorded in the DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.
         */
        var identity: kotlin.String? = null
        /**
         * The maximum number of results that are returned per call. Use `nextPageToken` to obtain further pages of results.
         *
         * This is an upper limit only; the actual number of results returned per call may be fewer than the specified maximum.
         */
        var maximumPageSize: kotlin.Int = 0
        /**
         * If `NextPageToken` is returned there are more results available. The value of `NextPageToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a `400` error: "`Specified token has exceeded its maximum lifetime`".
         *
         * The configured `maximumPageSize` determines how many results can be returned in a single call.
         *
         * The `nextPageToken` returned by this action cannot be used with GetWorkflowExecutionHistory to get the next page. You must call PollForDecisionTask again (with the `nextPageToken`) to retrieve the next page of history records. Calling PollForDecisionTask with a `nextPageToken` doesn't return a new decision task.
         */
        var nextPageToken: kotlin.String? = null
        /**
         * When set to `true`, returns the events in reverse order. By default the results are returned in ascending order of the `eventTimestamp` of the events.
         */
        var reverseOrder: kotlin.Boolean = false
        /**
         * Specifies the task list to poll for decision tasks.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
         */
        var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.PollForDecisionTaskRequest) : this() {
            this.domain = x.domain
            this.identity = x.identity
            this.maximumPageSize = x.maximumPageSize
            this.nextPageToken = x.nextPageToken
            this.reverseOrder = x.reverseOrder
            this.taskList = x.taskList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.PollForDecisionTaskRequest = PollForDecisionTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
