// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



class RegisterDomainRequest private constructor(builder: Builder) {
    /**
     * A text description of the domain.
     */
    val description: kotlin.String? = builder.description
    /**
     * Name of the domain to register. The name must be unique in the region that the domain is registered in.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
     */
    val name: kotlin.String? = builder.name
    /**
     * Tags to be added when registering a domain.
     *
     * Tags may only contain unicode letters, digits, whitespace, or these symbols: `_ . : / = + - @`.
     */
    val tags: List<ResourceTag>? = builder.tags
    /**
     * The duration (in days) that records and histories of workflow executions on the domain should be kept by the service. After the retention period, the workflow execution isn't available in the results of visibility calls.
     *
     * If you pass the value `NONE` or `0` (zero), then the workflow execution history isn't retained. As soon as the workflow execution completes, the execution record and its history are deleted.
     *
     * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits, see: [Amazon SWF Service Limits](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html) in the *Amazon SWF Developer Guide*.
     */
    val workflowExecutionRetentionPeriodInDays: kotlin.String? = builder.workflowExecutionRetentionPeriodInDays

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RegisterDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterDomainRequest(")
        append("description=$description,")
        append("name=$name,")
        append("tags=$tags,")
        append("workflowExecutionRetentionPeriodInDays=$workflowExecutionRetentionPeriodInDays)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionRetentionPeriodInDays?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterDomainRequest

        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (workflowExecutionRetentionPeriodInDays != other.workflowExecutionRetentionPeriodInDays) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RegisterDomainRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A text description of the domain.
         */
        var description: kotlin.String? = null
        /**
         * Name of the domain to register. The name must be unique in the region that the domain is registered in.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
         */
        var name: kotlin.String? = null
        /**
         * Tags to be added when registering a domain.
         *
         * Tags may only contain unicode letters, digits, whitespace, or these symbols: `_ . : / = + - @`.
         */
        var tags: List<ResourceTag>? = null
        /**
         * The duration (in days) that records and histories of workflow executions on the domain should be kept by the service. After the retention period, the workflow execution isn't available in the results of visibility calls.
         *
         * If you pass the value `NONE` or `0` (zero), then the workflow execution history isn't retained. As soon as the workflow execution completes, the execution record and its history are deleted.
         *
         * The maximum workflow execution retention period is 90 days. For more information about Amazon SWF service limits, see: [Amazon SWF Service Limits](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html) in the *Amazon SWF Developer Guide*.
         */
        var workflowExecutionRetentionPeriodInDays: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RegisterDomainRequest) : this() {
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
            this.workflowExecutionRetentionPeriodInDays = x.workflowExecutionRetentionPeriodInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RegisterDomainRequest = RegisterDomainRequest(this)
    }
}
