// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `SignalExternalWorkflowExecutionFailed` event.
 */
class SignalExternalWorkflowExecutionFailedEventAttributes private constructor(builder: Builder) {
    /**
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     *
     * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    val cause: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedCause? = builder.cause
    /**
     * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the workflow execution.
     */
    val control: kotlin.String? = builder.control
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `SignalExternalWorkflowExecution` decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The ID of the `SignalExternalWorkflowExecutionInitiated` event corresponding to the `SignalExternalWorkflowExecution` decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    val initiatedEventId: kotlin.Long = builder.initiatedEventId
    /**
     * The `runId` of the external workflow execution that the signal was being delivered to.
     */
    val runId: kotlin.String? = builder.runId
    /**
     * The `workflowId` of the external workflow execution that the signal was being delivered to.
     */
    val workflowId: kotlin.String? = builder.workflowId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SignalExternalWorkflowExecutionFailedEventAttributes(")
        append("cause=$cause,")
        append("control=$control,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("initiatedEventId=$initiatedEventId,")
        append("runId=$runId,")
        append("workflowId=$workflowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cause?.hashCode() ?: 0
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (initiatedEventId.hashCode())
        result = 31 * result + (runId?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SignalExternalWorkflowExecutionFailedEventAttributes

        if (cause != other.cause) return false
        if (control != other.control) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (initiatedEventId != other.initiatedEventId) return false
        if (runId != other.runId) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
         *
         * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
         */
        var cause: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedCause? = null
        /**
         * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the workflow execution.
         */
        var control: kotlin.String? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `SignalExternalWorkflowExecution` decision for this signal. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The ID of the `SignalExternalWorkflowExecutionInitiated` event corresponding to the `SignalExternalWorkflowExecution` decision to request this signal. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        var initiatedEventId: kotlin.Long = 0L
        /**
         * The `runId` of the external workflow execution that the signal was being delivered to.
         */
        var runId: kotlin.String? = null
        /**
         * The `workflowId` of the external workflow execution that the signal was being delivered to.
         */
        var workflowId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes) : this() {
            this.cause = x.cause
            this.control = x.control
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.initiatedEventId = x.initiatedEventId
            this.runId = x.runId
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes = SignalExternalWorkflowExecutionFailedEventAttributes(this)
    }
}
