// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



class StartWorkflowExecutionRequest private constructor(builder: Builder) {
    /**
     * If set, specifies the policy to use for the child workflow executions of this workflow execution if it is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using RegisterWorkflowType.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     *
     * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
     */
    val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = builder.childPolicy
    /**
     * The name of the domain in which the workflow execution is created.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.
     *
     * The duration is specified in seconds; an integer greater than or equal to `0`. Exceeding this limit causes the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.
     *
     * An execution start-to-close timeout must be specified either through this parameter or as a default when the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is specified, a fault is returned.
     */
    val executionStartToCloseTimeout: kotlin.String? = builder.executionStartToCloseTimeout
    /**
     * The input for the workflow execution. This is a free form string which should be meaningful to the workflow you are starting. This `input` is made available to the new workflow execution in the `WorkflowExecutionStarted` history event.
     */
    val input: kotlin.String? = builder.input
    /**
     * The IAM role to attach to this workflow execution.
     *
     * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a `ScheduleLambdaFunctionFailed` history event. For more information, see [https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html](https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html) in the *Amazon SWF Developer Guide*.
     */
    val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and specifying a TagFilter.
     */
    val tagList: List<String>? = builder.tagList
    /**
     * The task list to use for the decision tasks generated for this workflow execution. This overrides the `defaultTaskList` specified when registering the workflow type.
     *
     * A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
     */
    val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * The task priority to use for this workflow execution. This overrides any default priority that was assigned when the workflow type was registered. If not set, then the default task priority for the workflow type is used. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the `defaultTaskStartToCloseTimout` specified when registering the workflow type using RegisterWorkflowType.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     *
     * A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.
     */
    val taskStartToCloseTimeout: kotlin.String? = builder.taskStartToCloseTimeout
    /**
     * The user defined identifier associated with the workflow execution. You can use this to associate a custom identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically a *restart* of a previous execution. You cannot have two open workflow executions with the same `workflowId` at the same time within the same domain.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
     */
    val workflowId: kotlin.String? = builder.workflowId
    /**
     * The type of the workflow to start.
     */
    val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartWorkflowExecutionRequest(")
        append("childPolicy=$childPolicy,")
        append("domain=$domain,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("input=$input,")
        append("lambdaRole=$lambdaRole,")
        append("tagList=$tagList,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout,")
        append("workflowId=$workflowId,")
        append("workflowType=$workflowType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (executionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartWorkflowExecutionRequest

        if (childPolicy != other.childPolicy) return false
        if (domain != other.domain) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (input != other.input) return false
        if (lambdaRole != other.lambdaRole) return false
        if (tagList != other.tagList) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false
        if (workflowId != other.workflowId) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If set, specifies the policy to use for the child workflow executions of this workflow execution if it is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using RegisterWorkflowType.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         *
         * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
         */
        var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * The name of the domain in which the workflow execution is created.
         */
        var domain: kotlin.String? = null
        /**
         * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.
         *
         * The duration is specified in seconds; an integer greater than or equal to `0`. Exceeding this limit causes the workflow execution to time out. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for this timeout; there is a one-year max limit on the time that a workflow execution can run.
         *
         * An execution start-to-close timeout must be specified either through this parameter or as a default when the workflow type is registered. If neither this parameter nor a default execution start-to-close timeout is specified, a fault is returned.
         */
        var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The input for the workflow execution. This is a free form string which should be meaningful to the workflow you are starting. This `input` is made available to the new workflow execution in the `WorkflowExecutionStarted` history event.
         */
        var input: kotlin.String? = null
        /**
         * The IAM role to attach to this workflow execution.
         *
         * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role, any attempt to schedule a Lambda task fails. This results in a `ScheduleLambdaFunctionFailed` history event. For more information, see [https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html](https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html) in the *Amazon SWF Developer Guide*.
         */
        var lambdaRole: kotlin.String? = null
        /**
         * The list of tags to associate with the workflow execution. You can specify a maximum of 5 tags. You can list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and specifying a TagFilter.
         */
        var tagList: List<String>? = null
        /**
         * The task list to use for the decision tasks generated for this workflow execution. This overrides the `defaultTaskList` specified when registering the workflow type.
         *
         * A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
         */
        var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The task priority to use for this workflow execution. This overrides any default priority that was assigned when the workflow type was registered. If not set, then the default task priority for the workflow type is used. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        var taskPriority: kotlin.String? = null
        /**
         * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the `defaultTaskStartToCloseTimout` specified when registering the workflow type using RegisterWorkflowType.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         *
         * A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.
         */
        var taskStartToCloseTimeout: kotlin.String? = null
        /**
         * The user defined identifier associated with the workflow execution. You can use this to associate a custom identifier with the workflow execution. You may specify the same identifier if a workflow execution is logically a *restart* of a previous execution. You cannot have two open workflow executions with the same `workflowId` at the same time within the same domain.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not *be* the literal string `arn`.
         */
        var workflowId: kotlin.String? = null
        /**
         * The type of the workflow to start.
         */
        var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionRequest) : this() {
            this.childPolicy = x.childPolicy
            this.domain = x.domain
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.input = x.input
            this.lambdaRole = x.lambdaRole
            this.tagList = x.tagList
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
            this.workflowId = x.workflowId
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionRequest = StartWorkflowExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }
    }
}
