// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * The configuration settings of a workflow type.
 */
class WorkflowTypeConfiguration private constructor(builder: Builder) {
    /**
     * The default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     */
    val defaultChildPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = builder.defaultChildPolicy
    /**
     * The default maximum duration, specified when registering the workflow type, for executions of this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val defaultExecutionStartToCloseTimeout: kotlin.String? = builder.defaultExecutionStartToCloseTimeout
    /**
     * The default IAM role attached to this workflow type.
     *
     * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when starting this workflow type, the default Lambda role is attached to the execution. For more information, see [https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html](https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html) in the *Amazon SWF Developer Guide*.
     */
    val defaultLambdaRole: kotlin.String? = builder.defaultLambdaRole
    /**
     * The default task list, specified when registering the workflow type, for decisions tasks scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
     */
    val defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.defaultTaskList
    /**
     * The default task priority, specified when registering the workflow type, for all decision tasks of this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution` decision.
     *
     * Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    val defaultTaskPriority: kotlin.String? = builder.defaultTaskPriority
    /**
     * The default maximum duration, specified when registering the workflow type, that a decision task for executions of this workflow type might take before returning completion or failure. If the task doesn'tdo close in the specified time then the task is automatically timed out and rescheduled. If the decider eventually reports a completion or failure, it is ignored. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    val defaultTaskStartToCloseTimeout: kotlin.String? = builder.defaultTaskStartToCloseTimeout

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.WorkflowTypeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowTypeConfiguration(")
        append("defaultChildPolicy=$defaultChildPolicy,")
        append("defaultExecutionStartToCloseTimeout=$defaultExecutionStartToCloseTimeout,")
        append("defaultLambdaRole=$defaultLambdaRole,")
        append("defaultTaskList=$defaultTaskList,")
        append("defaultTaskPriority=$defaultTaskPriority,")
        append("defaultTaskStartToCloseTimeout=$defaultTaskStartToCloseTimeout)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultChildPolicy?.hashCode() ?: 0
        result = 31 * result + (defaultExecutionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (defaultLambdaRole?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskList?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskPriority?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskStartToCloseTimeout?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowTypeConfiguration

        if (defaultChildPolicy != other.defaultChildPolicy) return false
        if (defaultExecutionStartToCloseTimeout != other.defaultExecutionStartToCloseTimeout) return false
        if (defaultLambdaRole != other.defaultLambdaRole) return false
        if (defaultTaskList != other.defaultTaskList) return false
        if (defaultTaskPriority != other.defaultTaskPriority) return false
        if (defaultTaskStartToCloseTimeout != other.defaultTaskStartToCloseTimeout) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.WorkflowTypeConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         */
        var defaultChildPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * The default maximum duration, specified when registering the workflow type, for executions of this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var defaultExecutionStartToCloseTimeout: kotlin.String? = null
        /**
         * The default IAM role attached to this workflow type.
         *
         * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when starting this workflow type, the default Lambda role is attached to the execution. For more information, see [https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html](https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html) in the *Amazon SWF Developer Guide*.
         */
        var defaultLambdaRole: kotlin.String? = null
        /**
         * The default task list, specified when registering the workflow type, for decisions tasks scheduled for workflow executions of this type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
         */
        var defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The default task priority, specified when registering the workflow type, for all decision tasks of this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution` decision.
         *
         * Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        var defaultTaskPriority: kotlin.String? = null
        /**
         * The default maximum duration, specified when registering the workflow type, that a decision task for executions of this workflow type might take before returning completion or failure. If the task doesn'tdo close in the specified time then the task is automatically timed out and rescheduled. If the decider eventually reports a completion or failure, it is ignored. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        var defaultTaskStartToCloseTimeout: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.WorkflowTypeConfiguration) : this() {
            this.defaultChildPolicy = x.defaultChildPolicy
            this.defaultExecutionStartToCloseTimeout = x.defaultExecutionStartToCloseTimeout
            this.defaultLambdaRole = x.defaultLambdaRole
            this.defaultTaskList = x.defaultTaskList
            this.defaultTaskPriority = x.defaultTaskPriority
            this.defaultTaskStartToCloseTimeout = x.defaultTaskStartToCloseTimeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.WorkflowTypeConfiguration = WorkflowTypeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        fun defaultTaskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.defaultTaskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }
    }
}
