// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.swf.model.ActivityTypeInfo
import aws.sdk.kotlin.services.swf.model.ListActivityTypesResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListActivityTypesOperationDeserializer: HttpDeserialize<ListActivityTypesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListActivityTypesResponse {
        if (!response.status.isSuccess()) {
            throwListActivityTypesError(context, response)
        }
        val builder = ListActivityTypesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListActivityTypesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListActivityTypesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListActivityTypesOperationBody(builder: ListActivityTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextPageToken"))
    val TYPEINFOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("typeInfos"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(TYPEINFOS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                TYPEINFOS_DESCRIPTOR.index -> builder.typeInfos =
                    deserializer.deserializeList(TYPEINFOS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActivityTypeInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActivityTypeInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
