// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.swf.model.ActivityType
import aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.WorkflowExecution
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PollForActivityTaskOperationDeserializer: HttpDeserialize<PollForActivityTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PollForActivityTaskResponse {
        if (!response.status.isSuccess()) {
            throwPollForActivityTaskError(context, response)
        }
        val builder = PollForActivityTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePollForActivityTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPollForActivityTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePollForActivityTaskOperationBody(builder: PollForActivityTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("activityId"))
    val ACTIVITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("activityType"))
    val INPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("input"))
    val STARTEDEVENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("startedEventId"))
    val TASKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskToken"))
    val WORKFLOWEXECUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("workflowExecution"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVITYID_DESCRIPTOR)
        field(ACTIVITYTYPE_DESCRIPTOR)
        field(INPUT_DESCRIPTOR)
        field(STARTEDEVENTID_DESCRIPTOR)
        field(TASKTOKEN_DESCRIPTOR)
        field(WORKFLOWEXECUTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVITYID_DESCRIPTOR.index -> builder.activityId = deserializeString()
                ACTIVITYTYPE_DESCRIPTOR.index -> builder.activityType = deserializeActivityTypeDocument(deserializer)
                INPUT_DESCRIPTOR.index -> builder.input = deserializeString()
                STARTEDEVENTID_DESCRIPTOR.index -> builder.startedEventId = deserializeLong()
                TASKTOKEN_DESCRIPTOR.index -> builder.taskToken = deserializeString()
                WORKFLOWEXECUTION_DESCRIPTOR.index -> builder.workflowExecution = deserializeWorkflowExecutionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
