// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `CompleteWorkflowExecution` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class CompleteWorkflowExecutionDecisionAttributes private constructor(builder: Builder) {
    /**
     * The result of the workflow execution. The form of the result is implementation defined.
     */
    public val result: kotlin.String? = builder.result

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompleteWorkflowExecutionDecisionAttributes(")
        append("result=$result)")
    }

    override fun hashCode(): kotlin.Int {
        var result = result?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompleteWorkflowExecutionDecisionAttributes

        if (result != other.result) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The result of the workflow execution. The form of the result is implementation defined.
         */
        public var result: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes) : this() {
            this.result = x.result
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionDecisionAttributes = CompleteWorkflowExecutionDecisionAttributes(this)
    }
}
