// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a workflow execution.
 */
public class DescribeWorkflowExecutionResponse private constructor(builder: Builder) {
    /**
     * The configuration settings for this workflow execution including timeout values, tasklist etc.
     */
    public val executionConfiguration: aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration? = builder.executionConfiguration
    /**
     * Information about the workflow execution.
     */
    public val executionInfo: aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo? = builder.executionInfo
    /**
     * The time when the last activity task was scheduled for this workflow execution. You can use this information to determine if the workflow has not made progress for an unusually long period of time and might require a corrective action.
     */
    public val latestActivityTaskTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.latestActivityTaskTimestamp
    /**
     * The latest executionContext provided by the decider for this workflow execution. A decider can provide an executionContext (a free-form string) when closing a decision task using RespondDecisionTaskCompleted.
     */
    public val latestExecutionContext: kotlin.String? = builder.latestExecutionContext
    /**
     * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
     */
    public val openCounts: aws.sdk.kotlin.services.swf.model.WorkflowExecutionOpenCounts? = builder.openCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeWorkflowExecutionResponse(")
        append("executionConfiguration=$executionConfiguration,")
        append("executionInfo=$executionInfo,")
        append("latestActivityTaskTimestamp=$latestActivityTaskTimestamp,")
        append("latestExecutionContext=$latestExecutionContext,")
        append("openCounts=$openCounts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionConfiguration?.hashCode() ?: 0
        result = 31 * result + (executionInfo?.hashCode() ?: 0)
        result = 31 * result + (latestActivityTaskTimestamp?.hashCode() ?: 0)
        result = 31 * result + (latestExecutionContext?.hashCode() ?: 0)
        result = 31 * result + (openCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeWorkflowExecutionResponse

        if (executionConfiguration != other.executionConfiguration) return false
        if (executionInfo != other.executionInfo) return false
        if (latestActivityTaskTimestamp != other.latestActivityTaskTimestamp) return false
        if (latestExecutionContext != other.latestExecutionContext) return false
        if (openCounts != other.openCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration settings for this workflow execution including timeout values, tasklist etc.
         */
        public var executionConfiguration: aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration? = null
        /**
         * Information about the workflow execution.
         */
        public var executionInfo: aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo? = null
        /**
         * The time when the last activity task was scheduled for this workflow execution. You can use this information to determine if the workflow has not made progress for an unusually long period of time and might require a corrective action.
         */
        public var latestActivityTaskTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest executionContext provided by the decider for this workflow execution. A decider can provide an executionContext (a free-form string) when closing a decision task using RespondDecisionTaskCompleted.
         */
        public var latestExecutionContext: kotlin.String? = null
        /**
         * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
         */
        public var openCounts: aws.sdk.kotlin.services.swf.model.WorkflowExecutionOpenCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionResponse) : this() {
            this.executionConfiguration = x.executionConfiguration
            this.executionInfo = x.executionInfo
            this.latestActivityTaskTimestamp = x.latestActivityTaskTimestamp
            this.latestExecutionContext = x.latestExecutionContext
            this.openCounts = x.openCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionResponse = DescribeWorkflowExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration] inside the given [block]
         */
        public fun executionConfiguration(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration.Builder.() -> kotlin.Unit) {
            this.executionConfiguration = aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo] inside the given [block]
         */
        public fun executionInfo(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo.Builder.() -> kotlin.Unit) {
            this.executionInfo = aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionOpenCounts] inside the given [block]
         */
        public fun openCounts(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionOpenCounts.Builder.() -> kotlin.Unit) {
            this.openCounts = aws.sdk.kotlin.services.swf.model.WorkflowExecutionOpenCounts.invoke(block)
        }
    }
}
