// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Unit of work sent to an activity worker.
 */
public class PollForActivityTaskResponse private constructor(builder: Builder) {
    /**
     * The unique ID of the task.
     */
    public val activityId: kotlin.String? = builder.activityId
    /**
     * The type of this activity task.
     */
    public val activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = builder.activityType
    /**
     * The inputs provided when the activity task was scheduled. The form of the input is user defined and should be meaningful to the activity implementation.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The ID of the `ActivityTaskStarted` event recorded in the history.
     */
    public val startedEventId: kotlin.Long = builder.startedEventId
    /**
     * The opaque string used as a handle on the task. This token is used by workers to communicate progress and response information back to the system about the task.
     */
    public val taskToken: kotlin.String? = builder.taskToken
    /**
     * The workflow execution that started this activity task.
     */
    public val workflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = builder.workflowExecution

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PollForActivityTaskResponse(")
        append("activityId=$activityId,")
        append("activityType=$activityType,")
        append("input=$input,")
        append("startedEventId=$startedEventId,")
        append("taskToken=$taskToken,")
        append("workflowExecution=$workflowExecution)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId?.hashCode() ?: 0
        result = 31 * result + (activityType?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (startedEventId.hashCode())
        result = 31 * result + (taskToken?.hashCode() ?: 0)
        result = 31 * result + (workflowExecution?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PollForActivityTaskResponse

        if (activityId != other.activityId) return false
        if (activityType != other.activityType) return false
        if (input != other.input) return false
        if (startedEventId != other.startedEventId) return false
        if (taskToken != other.taskToken) return false
        if (workflowExecution != other.workflowExecution) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of the task.
         */
        public var activityId: kotlin.String? = null
        /**
         * The type of this activity task.
         */
        public var activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = null
        /**
         * The inputs provided when the activity task was scheduled. The form of the input is user defined and should be meaningful to the activity implementation.
         */
        public var input: kotlin.String? = null
        /**
         * The ID of the `ActivityTaskStarted` event recorded in the history.
         */
        public var startedEventId: kotlin.Long = 0L
        /**
         * The opaque string used as a handle on the task. This token is used by workers to communicate progress and response information back to the system about the task.
         */
        public var taskToken: kotlin.String? = null
        /**
         * The workflow execution that started this activity task.
         */
        public var workflowExecution: aws.sdk.kotlin.services.swf.model.WorkflowExecution? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse) : this() {
            this.activityId = x.activityId
            this.activityType = x.activityType
            this.input = x.input
            this.startedEventId = x.startedEventId
            this.taskToken = x.taskToken
            this.workflowExecution = x.workflowExecution
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse = PollForActivityTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityType] inside the given [block]
         */
        public fun activityType(block: aws.sdk.kotlin.services.swf.model.ActivityType.Builder.() -> kotlin.Unit) {
            this.activityType = aws.sdk.kotlin.services.swf.model.ActivityType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecution] inside the given [block]
         */
        public fun workflowExecution(block: aws.sdk.kotlin.services.swf.model.WorkflowExecution.Builder.() -> kotlin.Unit) {
            this.workflowExecution = aws.sdk.kotlin.services.swf.model.WorkflowExecution.invoke(block)
        }
    }
}
