// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `RequestCancelExternalWorkflowExecution` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class RequestCancelExternalWorkflowExecutionDecisionAttributes private constructor(builder: Builder) {
    /**
     * The data attached to the event that can be used by the decider in subsequent workflow tasks.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The `runId` of the external workflow execution to cancel.
     */
    public val runId: kotlin.String? = builder.runId
    /**
     * The `workflowId` of the external workflow execution to cancel.
     */
    public val workflowId: kotlin.String? = builder.workflowId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestCancelExternalWorkflowExecutionDecisionAttributes(")
        append("control=$control,")
        append("runId=$runId,")
        append("workflowId=$workflowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = control?.hashCode() ?: 0
        result = 31 * result + (runId?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestCancelExternalWorkflowExecutionDecisionAttributes

        if (control != other.control) return false
        if (runId != other.runId) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data attached to the event that can be used by the decider in subsequent workflow tasks.
         */
        public var control: kotlin.String? = null
        /**
         * The `runId` of the external workflow execution to cancel.
         */
        public var runId: kotlin.String? = null
        /**
         * The `workflowId` of the external workflow execution to cancel.
         */
        public var workflowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes) : this() {
            this.control = x.control
            this.runId = x.runId
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes = RequestCancelExternalWorkflowExecutionDecisionAttributes(this)
    }
}
