// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `RequestCancelExternalWorkflowExecutionFailed` event.
 */
public class RequestCancelExternalWorkflowExecutionFailedEventAttributes private constructor(builder: Builder) {
    /**
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     *
     * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public val cause: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedCause? = builder.cause
    /**
     * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the workflow execution.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `RequestCancelExternalWorkflowExecution` decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The ID of the `RequestCancelExternalWorkflowExecutionInitiated` event corresponding to the `RequestCancelExternalWorkflowExecution` decision to cancel this external workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val initiatedEventId: kotlin.Long = builder.initiatedEventId
    /**
     * The `runId` of the external workflow execution.
     */
    public val runId: kotlin.String? = builder.runId
    /**
     * The `workflowId` of the external workflow to which the cancel request was to be delivered.
     */
    public val workflowId: kotlin.String? = builder.workflowId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestCancelExternalWorkflowExecutionFailedEventAttributes(")
        append("cause=$cause,")
        append("control=$control,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("initiatedEventId=$initiatedEventId,")
        append("runId=$runId,")
        append("workflowId=$workflowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cause?.hashCode() ?: 0
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (initiatedEventId.hashCode())
        result = 31 * result + (runId?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestCancelExternalWorkflowExecutionFailedEventAttributes

        if (cause != other.cause) return false
        if (control != other.control) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (initiatedEventId != other.initiatedEventId) return false
        if (runId != other.runId) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
         *
         * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
         */
        public var cause: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedCause? = null
        /**
         * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the workflow execution.
         */
        public var control: kotlin.String? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `RequestCancelExternalWorkflowExecution` decision for this cancellation request. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The ID of the `RequestCancelExternalWorkflowExecutionInitiated` event corresponding to the `RequestCancelExternalWorkflowExecution` decision to cancel this external workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var initiatedEventId: kotlin.Long = 0L
        /**
         * The `runId` of the external workflow execution.
         */
        public var runId: kotlin.String? = null
        /**
         * The `workflowId` of the external workflow to which the cancel request was to be delivered.
         */
        public var workflowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes) : this() {
            this.cause = x.cause
            this.control = x.control
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.initiatedEventId = x.initiatedEventId
            this.runId = x.runId
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes = RequestCancelExternalWorkflowExecutionFailedEventAttributes(this)
    }
}
