// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `StartChildWorkflowExecutionFailed` event.
 */
public class StartChildWorkflowExecutionFailedEventAttributes private constructor(builder: Builder) {
    /**
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     *
     * When `cause` is set to `OPERATION_NOT_PERMITTED`, the decision fails because it lacks sufficient permissions. For details and example IAM policies, see [ Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public val cause: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedCause? = builder.cause
    /**
     * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the child workflow execution.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartChildWorkflowExecution`Decision to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * When the `cause` is `WORKFLOW_ALREADY_RUNNING`, `initiatedEventId` is the ID of the `StartChildWorkflowExecutionInitiated` event that corresponds to the `StartChildWorkflowExecution`Decision to start the workflow execution. You can use this information to diagnose problems by tracing back the chain of events leading up to this event.
     *
     * When the `cause` isn't `WORKFLOW_ALREADY_RUNNING`, `initiatedEventId` is set to `0` because the `StartChildWorkflowExecutionInitiated` event doesn't exist.
     */
    public val initiatedEventId: kotlin.Long = builder.initiatedEventId
    /**
     * The `workflowId` of the child workflow execution.
     */
    public val workflowId: kotlin.String? = builder.workflowId
    /**
     * The workflow type provided in the `StartChildWorkflowExecution`Decision that failed.
     */
    public val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartChildWorkflowExecutionFailedEventAttributes(")
        append("cause=$cause,")
        append("control=$control,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("initiatedEventId=$initiatedEventId,")
        append("workflowId=$workflowId,")
        append("workflowType=$workflowType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cause?.hashCode() ?: 0
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (initiatedEventId.hashCode())
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartChildWorkflowExecutionFailedEventAttributes

        if (cause != other.cause) return false
        if (control != other.control) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (initiatedEventId != other.initiatedEventId) return false
        if (workflowId != other.workflowId) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
         *
         * When `cause` is set to `OPERATION_NOT_PERMITTED`, the decision fails because it lacks sufficient permissions. For details and example IAM policies, see [ Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
         */
        public var cause: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedCause? = null
        /**
         * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the child workflow execution.
         */
        public var control: kotlin.String? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartChildWorkflowExecution`Decision to request this child workflow execution. This information can be useful for diagnosing problems by tracing back the chain of events.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * When the `cause` is `WORKFLOW_ALREADY_RUNNING`, `initiatedEventId` is the ID of the `StartChildWorkflowExecutionInitiated` event that corresponds to the `StartChildWorkflowExecution`Decision to start the workflow execution. You can use this information to diagnose problems by tracing back the chain of events leading up to this event.
         *
         * When the `cause` isn't `WORKFLOW_ALREADY_RUNNING`, `initiatedEventId` is set to `0` because the `StartChildWorkflowExecutionInitiated` event doesn't exist.
         */
        public var initiatedEventId: kotlin.Long = 0L
        /**
         * The `workflowId` of the child workflow execution.
         */
        public var workflowId: kotlin.String? = null
        /**
         * The workflow type provided in the `StartChildWorkflowExecution`Decision that failed.
         */
        public var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes) : this() {
            this.cause = x.cause
            this.control = x.control
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.initiatedEventId = x.initiatedEventId
            this.workflowId = x.workflowId
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes = StartChildWorkflowExecutionFailedEventAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        public fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }
    }
}
