// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `StartTimer` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class StartTimerDecisionAttributes private constructor(builder: Builder) {
    /**
     * The data attached to the event that can be used by the decider in subsequent workflow tasks.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The duration to wait before firing the timer.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`.
     */
    public val startToFireTimeout: kotlin.String? = builder.startToFireTimeout
    /**
     * The unique ID of the timer.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not contain the literal string `arn`.
     */
    public val timerId: kotlin.String? = builder.timerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTimerDecisionAttributes(")
        append("control=$control,")
        append("startToFireTimeout=$startToFireTimeout,")
        append("timerId=$timerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = control?.hashCode() ?: 0
        result = 31 * result + (startToFireTimeout?.hashCode() ?: 0)
        result = 31 * result + (timerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTimerDecisionAttributes

        if (control != other.control) return false
        if (startToFireTimeout != other.startToFireTimeout) return false
        if (timerId != other.timerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data attached to the event that can be used by the decider in subsequent workflow tasks.
         */
        public var control: kotlin.String? = null
        /**
         * The duration to wait before firing the timer.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`.
         */
        public var startToFireTimeout: kotlin.String? = null
        /**
         * The unique ID of the timer.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not contain the literal string `arn`.
         */
        public var timerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes) : this() {
            this.control = x.control
            this.startToFireTimeout = x.startToFireTimeout
            this.timerId = x.timerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.StartTimerDecisionAttributes = StartTimerDecisionAttributes(this)
    }
}
