// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



public class TerminateWorkflowExecutionRequest private constructor(builder: Builder) {
    /**
     * If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated. This policy overrides the child policy specified for the workflow execution at registration time or when starting the execution.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     *
     * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
     */
    public val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = builder.childPolicy
    /**
     * Details for terminating the workflow execution.
     */
    public val details: kotlin.String? = builder.details
    /**
     * The domain of the workflow execution to terminate.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * A descriptive reason for terminating the workflow execution.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The runId of the workflow execution to terminate.
     */
    public val runId: kotlin.String? = builder.runId
    /**
     * The workflowId of the workflow execution to terminate.
     */
    public val workflowId: kotlin.String? = builder.workflowId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TerminateWorkflowExecutionRequest(")
        append("childPolicy=$childPolicy,")
        append("details=$details,")
        append("domain=$domain,")
        append("reason=$reason,")
        append("runId=$runId,")
        append("workflowId=$workflowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy?.hashCode() ?: 0
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (runId?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TerminateWorkflowExecutionRequest

        if (childPolicy != other.childPolicy) return false
        if (details != other.details) return false
        if (domain != other.domain) return false
        if (reason != other.reason) return false
        if (runId != other.runId) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If set, specifies the policy to use for the child workflow executions of the workflow execution being terminated. This policy overrides the child policy specified for the workflow execution at registration time or when starting the execution.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         *
         * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
         */
        public var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * Details for terminating the workflow execution.
         */
        public var details: kotlin.String? = null
        /**
         * The domain of the workflow execution to terminate.
         */
        public var domain: kotlin.String? = null
        /**
         * A descriptive reason for terminating the workflow execution.
         */
        public var reason: kotlin.String? = null
        /**
         * The runId of the workflow execution to terminate.
         */
        public var runId: kotlin.String? = null
        /**
         * The workflowId of the workflow execution to terminate.
         */
        public var workflowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionRequest) : this() {
            this.childPolicy = x.childPolicy
            this.details = x.details
            this.domain = x.domain
            this.reason = x.reason
            this.runId = x.runId
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionRequest = TerminateWorkflowExecutionRequest(this)
    }
}
