// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `TimerCanceled` event.
 */
public class TimerCanceledEventAttributes private constructor(builder: Builder) {
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `CancelTimer` decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The ID of the `TimerStarted` event that was recorded when this timer was started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val startedEventId: kotlin.Long = builder.startedEventId
    /**
     * The unique ID of the timer that was canceled.
     */
    public val timerId: kotlin.String? = builder.timerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimerCanceledEventAttributes(")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("startedEventId=$startedEventId,")
        append("timerId=$timerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = decisionTaskCompletedEventId.hashCode()
        result = 31 * result + (startedEventId.hashCode())
        result = 31 * result + (timerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimerCanceledEventAttributes

        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (startedEventId != other.startedEventId) return false
        if (timerId != other.timerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `CancelTimer` decision to cancel this timer. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The ID of the `TimerStarted` event that was recorded when this timer was started. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var startedEventId: kotlin.Long = 0L
        /**
         * The unique ID of the timer that was canceled.
         */
        public var timerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes) : this() {
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.startedEventId = x.startedEventId
            this.timerId = x.timerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes = TimerCanceledEventAttributes(this)
    }
}
