// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `TimerStarted` event.
 */
public class TimerStartedEventAttributes private constructor(builder: Builder) {
    /**
     * Data attached to the event that can be used by the decider in subsequent workflow tasks.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartTimer` decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The duration of time after which the timer fires.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`.
     */
    public val startToFireTimeout: kotlin.String? = builder.startToFireTimeout
    /**
     * The unique ID of the timer that was started.
     */
    public val timerId: kotlin.String? = builder.timerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimerStartedEventAttributes(")
        append("control=$control,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("startToFireTimeout=$startToFireTimeout,")
        append("timerId=$timerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = control?.hashCode() ?: 0
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (startToFireTimeout?.hashCode() ?: 0)
        result = 31 * result + (timerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimerStartedEventAttributes

        if (control != other.control) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (startToFireTimeout != other.startToFireTimeout) return false
        if (timerId != other.timerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Data attached to the event that can be used by the decider in subsequent workflow tasks.
         */
        public var control: kotlin.String? = null
        /**
         * The ID of the `DecisionTaskCompleted` event corresponding to the decision task that resulted in the `StartTimer` decision for this activity task. This information can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The duration of time after which the timer fires.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`.
         */
        public var startToFireTimeout: kotlin.String? = null
        /**
         * The unique ID of the timer that was started.
         */
        public var timerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes) : this() {
            this.control = x.control
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.startToFireTimeout = x.startToFireTimeout
            this.timerId = x.timerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes = TimerStartedEventAttributes(this)
    }
}
