// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.swf.model.CountOpenWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CountOpenWorkflowExecutionsOperationDeserializer: HttpDeserialize<CountOpenWorkflowExecutionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CountOpenWorkflowExecutionsResponse {
        if (!response.status.isSuccess()) {
            throwCountOpenWorkflowExecutionsError(context, response)
        }
        val builder = CountOpenWorkflowExecutionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCountOpenWorkflowExecutionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCountOpenWorkflowExecutionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCountOpenWorkflowExecutionsOperationBody(builder: CountOpenWorkflowExecutionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("count"))
    val TRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("truncated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COUNT_DESCRIPTOR)
        field(TRUNCATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COUNT_DESCRIPTOR.index -> builder.count = deserializeInt()
                TRUNCATED_DESCRIPTOR.index -> builder.truncated = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
