// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.transcribe.model.*
import aws.sdk.kotlin.services.transcribe.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Transcribe"
const val ServiceApiVersion: String = "2017-10-26"
const val SdkVersion: String = "0.16.6-beta"

internal class DefaultTranscribeClient(override val config: TranscribeClient.Config) : TranscribeClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a new Call Analytics category.
     *
     * All categories are automatically applied to your Call Analytics jobs. Note that in order to apply your categories to your jobs, you must create them before submitting your job request, as categories cannot be applied retroactively.
     *
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .
     *
     * To update an existing category, see .
     *
     * To learn more about:
     * + Call Analytics categories, see [Creating categories](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html)
     * + Using rules, see [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) and refer to the data type
     * + Call Analytics, see [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html)
     */
    override suspend fun createCallAnalyticsCategory(input: CreateCallAnalyticsCategoryRequest): CreateCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<CreateCallAnalyticsCategoryRequest, CreateCallAnalyticsCategoryResponse> {
            serializer = CreateCallAnalyticsCategoryOperationSerializer()
            deserializer = CreateCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCallAnalyticsCategory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom language model.
     *
     * When creating a new language model, you must specify:
     * + If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model
     * + The location of your training and tuning files (this must be an Amazon S3 URI)
     * + The language of your model
     * + A unique name for your model
     *
     * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
     */
    override suspend fun createLanguageModel(input: CreateLanguageModelRequest): CreateLanguageModelResponse {
        val op = SdkHttpOperation.build<CreateLanguageModelRequest, CreateLanguageModelResponse> {
            serializer = CreateLanguageModelOperationSerializer()
            deserializer = CreateLanguageModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLanguageModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom medical vocabulary.
     *
     * Prior to creating a new medical vocabulary, you must first upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the `Phrases` flag; `CreateMedicalVocabulary` does not support the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Creating a custom vocabulary](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
     */
    override suspend fun createMedicalVocabulary(input: CreateMedicalVocabularyRequest): CreateMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<CreateMedicalVocabularyRequest, CreateMedicalVocabularyResponse> {
            serializer = CreateMedicalVocabularyOperationSerializer()
            deserializer = CreateMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMedicalVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom vocabulary.
     *
     * When creating a new vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request, or you can include a list of terms directly in your request using the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Creating a custom vocabulary](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
     */
    override suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse {
        val op = SdkHttpOperation.build<CreateVocabularyRequest, CreateVocabularyResponse> {
            serializer = CreateVocabularyOperationSerializer()
            deserializer = CreateVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom vocabulary filter.
     *
     * You can use vocabulary filters to mask, delete, or flag specific words from your transcript. Vocabulary filters are commonly used to mask profanity in transcripts.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
     */
    override suspend fun createVocabularyFilter(input: CreateVocabularyFilterRequest): CreateVocabularyFilterResponse {
        val op = SdkHttpOperation.build<CreateVocabularyFilterRequest, CreateVocabularyFilterResponse> {
            serializer = CreateVocabularyFilterOperationSerializer()
            deserializer = CreateVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVocabularyFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
     */
    override suspend fun deleteCallAnalyticsCategory(input: DeleteCallAnalyticsCategoryRequest): DeleteCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<DeleteCallAnalyticsCategoryRequest, DeleteCallAnalyticsCategoryResponse> {
            serializer = DeleteCallAnalyticsCategoryOperationSerializer()
            deserializer = DeleteCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCallAnalyticsCategory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
     */
    override suspend fun deleteCallAnalyticsJob(input: DeleteCallAnalyticsJobRequest): DeleteCallAnalyticsJobResponse {
        val op = SdkHttpOperation.build<DeleteCallAnalyticsJobRequest, DeleteCallAnalyticsJobResponse> {
            serializer = DeleteCallAnalyticsJobOperationSerializer()
            deserializer = DeleteCallAnalyticsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCallAnalyticsJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. Language model names are case sensitive.
     */
    override suspend fun deleteLanguageModel(input: DeleteLanguageModelRequest): DeleteLanguageModelResponse {
        val op = SdkHttpOperation.build<DeleteLanguageModelRequest, DeleteLanguageModelResponse> {
            serializer = DeleteLanguageModelOperationSerializer()
            deserializer = DeleteLanguageModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLanguageModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
     */
    override suspend fun deleteMedicalTranscriptionJob(input: DeleteMedicalTranscriptionJobRequest): DeleteMedicalTranscriptionJobResponse {
        val op = SdkHttpOperation.build<DeleteMedicalTranscriptionJobRequest, DeleteMedicalTranscriptionJobResponse> {
            serializer = DeleteMedicalTranscriptionJobOperationSerializer()
            deserializer = DeleteMedicalTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMedicalTranscriptionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the vocabulary you want to delete using `VocabularyName`. Vocabulary names are case sensitive.
     */
    override suspend fun deleteMedicalVocabulary(input: DeleteMedicalVocabularyRequest): DeleteMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteMedicalVocabularyRequest, DeleteMedicalVocabularyResponse> {
            serializer = DeleteMedicalVocabularyOperationSerializer()
            deserializer = DeleteMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMedicalVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
     */
    override suspend fun deleteTranscriptionJob(input: DeleteTranscriptionJobRequest): DeleteTranscriptionJobResponse {
        val op = SdkHttpOperation.build<DeleteTranscriptionJobRequest, DeleteTranscriptionJobResponse> {
            serializer = DeleteTranscriptionJobOperationSerializer()
            deserializer = DeleteTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTranscriptionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom vocabulary. To use this operation, specify the name of the vocabulary you want to delete using `VocabularyName`. Vocabulary names are case sensitive.
     */
    override suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteVocabularyRequest, DeleteVocabularyResponse> {
            serializer = DeleteVocabularyOperationSerializer()
            deserializer = DeleteVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a vocabulary filter. To use this operation, specify the name of the vocabulary filter you want to delete using `VocabularyFilterName`. Vocabulary filter names are case sensitive.
     */
    override suspend fun deleteVocabularyFilter(input: DeleteVocabularyFilterRequest): DeleteVocabularyFilterResponse {
        val op = SdkHttpOperation.build<DeleteVocabularyFilterRequest, DeleteVocabularyFilterResponse> {
            serializer = DeleteVocabularyFilterOperationSerializer()
            deserializer = DeleteVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVocabularyFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified custom language model.
     *
     * This operation also shows if the base language model you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.
     *
     * If you tried to create a new custom language model and the request wasn't successful, you can use `DescribeLanguageModel` to help identify the reason for this failure.
     *
     * To get a list of your custom language models, use the operation.
     */
    override suspend fun describeLanguageModel(input: DescribeLanguageModelRequest): DescribeLanguageModelResponse {
        val op = SdkHttpOperation.build<DescribeLanguageModelRequest, DescribeLanguageModelResponse> {
            serializer = DescribeLanguageModelOperationSerializer()
            deserializer = DescribeLanguageModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLanguageModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified Call Analytics category.
     *
     * To get a list of your Call Analytics categories, use the operation.
     */
    override suspend fun getCallAnalyticsCategory(input: GetCallAnalyticsCategoryRequest): GetCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<GetCallAnalyticsCategoryRequest, GetCallAnalyticsCategoryResponse> {
            serializer = GetCallAnalyticsCategoryOperationSerializer()
            deserializer = GetCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCallAnalyticsCategory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified Call Analytics job.
     *
     * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
     *
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in `RedactedMediaFileUri`.
     *
     * To get a list of your Call Analytics jobs, use the operation.
     */
    override suspend fun getCallAnalyticsJob(input: GetCallAnalyticsJobRequest): GetCallAnalyticsJobResponse {
        val op = SdkHttpOperation.build<GetCallAnalyticsJobRequest, GetCallAnalyticsJobResponse> {
            serializer = GetCallAnalyticsJobOperationSerializer()
            deserializer = GetCallAnalyticsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCallAnalyticsJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified medical transcription job.
     *
     * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * To get a list of your medical transcription jobs, use the operation.
     */
    override suspend fun getMedicalTranscriptionJob(input: GetMedicalTranscriptionJobRequest): GetMedicalTranscriptionJobResponse {
        val op = SdkHttpOperation.build<GetMedicalTranscriptionJobRequest, GetMedicalTranscriptionJobResponse> {
            serializer = GetMedicalTranscriptionJobOperationSerializer()
            deserializer = GetMedicalTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMedicalTranscriptionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified custom medical vocabulary.
     *
     * To view the status of the specified medical vocabulary, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
     *
     * To get a list of your custom medical vocabularies, use the operation.
     */
    override suspend fun getMedicalVocabulary(input: GetMedicalVocabularyRequest): GetMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<GetMedicalVocabularyRequest, GetMedicalVocabularyResponse> {
            serializer = GetMedicalVocabularyOperationSerializer()
            deserializer = GetMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMedicalVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified transcription job.
     *
     * To view the status of the specified transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled content redaction, the redacted transcript can be found at the location specified in `RedactedTranscriptFileUri`.
     *
     * To get a list of your transcription jobs, use the operation.
     */
    override suspend fun getTranscriptionJob(input: GetTranscriptionJobRequest): GetTranscriptionJobResponse {
        val op = SdkHttpOperation.build<GetTranscriptionJobRequest, GetTranscriptionJobResponse> {
            serializer = GetTranscriptionJobOperationSerializer()
            deserializer = GetTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTranscriptionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified custom vocabulary.
     *
     * To view the status of the specified vocabulary, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
     *
     * To get a list of your custom vocabularies, use the operation.
     */
    override suspend fun getVocabulary(input: GetVocabularyRequest): GetVocabularyResponse {
        val op = SdkHttpOperation.build<GetVocabularyRequest, GetVocabularyResponse> {
            serializer = GetVocabularyOperationSerializer()
            deserializer = GetVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the specified custom vocabulary filter.
     *
     * To view the status of the specified vocabulary filter, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary filter failed.
     *
     * To get a list of your custom vocabulary filters, use the operation.
     */
    override suspend fun getVocabularyFilter(input: GetVocabularyFilterRequest): GetVocabularyFilterResponse {
        val op = SdkHttpOperation.build<GetVocabularyFilterRequest, GetVocabularyFilterResponse> {
            serializer = GetVocabularyFilterOperationSerializer()
            deserializer = GetVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVocabularyFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     *
     * To get detailed information about a specific Call Analytics category, use the operation.
     */
    override suspend fun listCallAnalyticsCategories(input: ListCallAnalyticsCategoriesRequest): ListCallAnalyticsCategoriesResponse {
        val op = SdkHttpOperation.build<ListCallAnalyticsCategoriesRequest, ListCallAnalyticsCategoriesResponse> {
            serializer = ListCallAnalyticsCategoriesOperationSerializer()
            deserializer = ListCallAnalyticsCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCallAnalyticsCategories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
     *
     * To get detailed information about a specific Call Analytics job, use the operation.
     */
    override suspend fun listCallAnalyticsJobs(input: ListCallAnalyticsJobsRequest): ListCallAnalyticsJobsResponse {
        val op = SdkHttpOperation.build<ListCallAnalyticsJobsRequest, ListCallAnalyticsJobsResponse> {
            serializer = ListCallAnalyticsJobsOperationSerializer()
            deserializer = ListCallAnalyticsJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCallAnalyticsJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all language models are returned.
     *
     * To get detailed information about a specific custom language model, use the operation.
     */
    override suspend fun listLanguageModels(input: ListLanguageModelsRequest): ListLanguageModelsResponse {
        val op = SdkHttpOperation.build<ListLanguageModelsRequest, ListLanguageModelsResponse> {
            serializer = ListLanguageModelsOperationSerializer()
            deserializer = ListLanguageModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLanguageModels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
     *
     * To get detailed information about a specific medical transcription job, use the operation.
     */
    override suspend fun listMedicalTranscriptionJobs(input: ListMedicalTranscriptionJobsRequest): ListMedicalTranscriptionJobsResponse {
        val op = SdkHttpOperation.build<ListMedicalTranscriptionJobsRequest, ListMedicalTranscriptionJobsResponse> {
            serializer = ListMedicalTranscriptionJobsOperationSerializer()
            deserializer = ListMedicalTranscriptionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMedicalTranscriptionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
     *
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     */
    override suspend fun listMedicalVocabularies(input: ListMedicalVocabulariesRequest): ListMedicalVocabulariesResponse {
        val op = SdkHttpOperation.build<ListMedicalVocabulariesRequest, ListMedicalVocabulariesResponse> {
            serializer = ListMedicalVocabulariesOperationSerializer()
            deserializer = ListMedicalVocabulariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMedicalVocabularies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
     *
     * To get detailed information about a specific transcription job, use the operation.
     */
    override suspend fun listTranscriptionJobs(input: ListTranscriptionJobsRequest): ListTranscriptionJobsResponse {
        val op = SdkHttpOperation.build<ListTranscriptionJobsRequest, ListTranscriptionJobsResponse> {
            serializer = ListTranscriptionJobsOperationSerializer()
            deserializer = ListTranscriptionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTranscriptionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary, use the operation.
     */
    override suspend fun listVocabularies(input: ListVocabulariesRequest): ListVocabulariesResponse {
        val op = SdkHttpOperation.build<ListVocabulariesRequest, ListVocabulariesResponse> {
            serializer = ListVocabulariesOperationSerializer()
            deserializer = ListVocabulariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVocabularies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     */
    override suspend fun listVocabularyFilters(input: ListVocabularyFiltersRequest): ListVocabularyFiltersResponse {
        val op = SdkHttpOperation.build<ListVocabularyFiltersRequest, ListVocabularyFiltersResponse> {
            serializer = ListVocabularyFiltersOperationSerializer()
            deserializer = ListVocabularyFiltersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVocabularyFilters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many of the standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
     *
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see [Creating categories](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html).
     *
     * To make a `StartCallAnalyticsJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartCallAnalyticsJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `CallAnalyticsJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `DataAccessRoleArn`: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.
     * + `Media` (`MediaFileUri` or `RedactedMediaFileUri`): The Amazon S3 location of your media file.
     *
     * With Call Analytics, you can redact the audio contained in your media file by including `RedactedMediaFileUri`, instead of `MediaFileUri`, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the `RedactedMediaFileUri` field of your response.
     */
    override suspend fun startCallAnalyticsJob(input: StartCallAnalyticsJobRequest): StartCallAnalyticsJobResponse {
        val op = SdkHttpOperation.build<StartCallAnalyticsJobRequest, StartCallAnalyticsJobResponse> {
            serializer = StartCallAnalyticsJobOperationSerializer()
            deserializer = StartCallAnalyticsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartCallAnalyticsJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many of the standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to [How Amazon Transcribe Medical works](https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
     *
     * To make a `StartMedicalTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `MedicalTranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + `LanguageCode`: This must be `en-US`.
     * + `OutputBucketName`: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include `OutputKey`.
     * + `Specialty`: This must be `PRIMARYCARE`.
     * + `Type`: Choose whether your audio is a conversation or a dictation.
     */
    override suspend fun startMedicalTranscriptionJob(input: StartMedicalTranscriptionJobRequest): StartMedicalTranscriptionJobResponse {
        val op = SdkHttpOperation.build<StartMedicalTranscriptionJobRequest, StartMedicalTranscriptionJobResponse> {
            serializer = StartMedicalTranscriptionJobOperationSerializer()
            deserializer = StartMedicalTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMedicalTranscriptionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
     *
     * To make a `StartTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `TranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + One of `LanguageCode`, `IdentifyLanguage`, or `IdentifyMultipleLanguages`: If you know the language of your media file, specify it using the `LanguageCode` parameter; you can find all valid language codes in the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. If you don't know the languages spoken in your media, use either `IdentifyLanguage` or `IdentifyMultipleLanguages` and let Amazon Transcribe identify the languages for you.
     */
    override suspend fun startTranscriptionJob(input: StartTranscriptionJobRequest): StartTranscriptionJobResponse {
        val op = SdkHttpOperation.build<StartTranscriptionJobRequest, StartTranscriptionJobResponse> {
            serializer = StartTranscriptionJobOperationSerializer()
            deserializer = StartTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartTranscriptionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified Amazon Transcribe resource.
     *
     * If you include `UntagResource` in your request, you must also include `ResourceArn` and `TagKeys`.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified Call Analytics category with new rules. Note that the `UpdateCallAnalyticsCategory` operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
     *
     * To create a new category, see .
     */
    override suspend fun updateCallAnalyticsCategory(input: UpdateCallAnalyticsCategoryRequest): UpdateCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<UpdateCallAnalyticsCategoryRequest, UpdateCallAnalyticsCategoryResponse> {
            serializer = UpdateCallAnalyticsCategoryOperationSerializer()
            deserializer = UpdateCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCallAnalyticsCategory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.
     */
    override suspend fun updateMedicalVocabulary(input: UpdateMedicalVocabularyRequest): UpdateMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<UpdateMedicalVocabularyRequest, UpdateMedicalVocabularyResponse> {
            serializer = UpdateMedicalVocabularyOperationSerializer()
            deserializer = UpdateMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMedicalVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.
     */
    override suspend fun updateVocabulary(input: UpdateVocabularyRequest): UpdateVocabularyResponse {
        val op = SdkHttpOperation.build<UpdateVocabularyRequest, UpdateVocabularyResponse> {
            serializer = UpdateVocabularyOperationSerializer()
            deserializer = UpdateVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing vocabulary filter.
     */
    override suspend fun updateVocabularyFilter(input: UpdateVocabularyFilterRequest): UpdateVocabularyFilterResponse {
        val op = SdkHttpOperation.build<UpdateVocabularyFilterRequest, UpdateVocabularyFilterResponse> {
            serializer = UpdateVocabularyFilterOperationSerializer()
            deserializer = UpdateVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVocabularyFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transcribe"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "transcribe")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
