// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * A time range, in milliseconds, between two points in your media file.
 *
 * You can use `StartTime` and `EndTime` to search a custom segment. For example, setting `StartTime` to 10000 and `EndTime` to 50000 only searches for your specified criteria in the audio contained between the 10,000 millisecond mark and the 50,000 millisecond mark of your media file. You must use `StartTime` and `EndTime` as a set; that is, if you include one, you must include both.
 *
 * You can use also `First` to search from the start of the audio until the time you specify, or `Last` to search from the time you specify until the end of the audio. For example, setting `First` to 50000 only searches for your specified criteria in the audio contained between the start of the media file to the 50,000 millisecond mark. You can use `First` and `Last` independently of each other.
 *
 * If you prefer to use percentage instead of milliseconds, see .
 */
class AbsoluteTimeRange private constructor(builder: Builder) {
    /**
     * The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your audio. If you include `EndTime` in your request, you must also include `StartTime`.
     */
    val endTime: kotlin.Long? = builder.endTime
    /**
     * The time, in milliseconds, from the start of your media file until the value you specify in which Amazon Transcribe searches for your specified criteria.
     */
    val first: kotlin.Long? = builder.first
    /**
     * The time, in milliseconds, from the value you specify until the end of your media file in which Amazon Transcribe searches for your specified criteria.
     */
    val last: kotlin.Long? = builder.last
    /**
     * The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your audio. If you include `StartTime` in your request, you must also include `EndTime`.
     */
    val startTime: kotlin.Long? = builder.startTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AbsoluteTimeRange(")
        append("endTime=$endTime,")
        append("first=$first,")
        append("last=$last,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (first?.hashCode() ?: 0)
        result = 31 * result + (last?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AbsoluteTimeRange

        if (endTime != other.endTime) return false
        if (first != other.first) return false
        if (last != other.last) return false
        if (startTime != other.startTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your audio. If you include `EndTime` in your request, you must also include `StartTime`.
         */
        var endTime: kotlin.Long? = null
        /**
         * The time, in milliseconds, from the start of your media file until the value you specify in which Amazon Transcribe searches for your specified criteria.
         */
        var first: kotlin.Long? = null
        /**
         * The time, in milliseconds, from the value you specify until the end of your media file in which Amazon Transcribe searches for your specified criteria.
         */
        var last: kotlin.Long? = null
        /**
         * The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your audio. If you include `StartTime` in your request, you must also include `EndTime`.
         */
        var startTime: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange) : this() {
            this.endTime = x.endTime
            this.first = x.first
            this.last = x.last
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange = AbsoluteTimeRange(this)
    }
}
