// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides you with the properties of the Call Analytics category you specified in your request. This includes the list of rules that define the specified category.
 */
class CategoryProperties private constructor(builder: Builder) {
    /**
     * The name of the Call Analytics category. Category names are case sensitive and must be unique within an Amazon Web Services account.
     */
    val categoryName: kotlin.String? = builder.categoryName
    /**
     * The date and time the specified Call Analytics category was created.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
     */
    val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The date and time the specified Call Analytics category was last updated.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-05T12:45:32.691000-07:00` represents 12:45 PM UTC-7 on May 5, 2022.
     */
    val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The rules used to define a Call Analytics category. Each category can have between 1 and 20 rules.
     */
    val rules: List<Rule>? = builder.rules

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CategoryProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CategoryProperties(")
        append("categoryName=$categoryName,")
        append("createTime=$createTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("rules=$rules)")
    }

    override fun hashCode(): kotlin.Int {
        var result = categoryName?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CategoryProperties

        if (categoryName != other.categoryName) return false
        if (createTime != other.createTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (rules != other.rules) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CategoryProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Call Analytics category. Category names are case sensitive and must be unique within an Amazon Web Services account.
         */
        var categoryName: kotlin.String? = null
        /**
         * The date and time the specified Call Analytics category was created.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
         */
        var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the specified Call Analytics category was last updated.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-05T12:45:32.691000-07:00` represents 12:45 PM UTC-7 on May 5, 2022.
         */
        var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The rules used to define a Call Analytics category. Each category can have between 1 and 20 rules.
         */
        var rules: List<Rule>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CategoryProperties) : this() {
            this.categoryName = x.categoryName
            this.createTime = x.createTime
            this.lastUpdateTime = x.lastUpdateTime
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CategoryProperties = CategoryProperties(this)
    }
}
