// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



class CreateVocabularyFilterRequest private constructor(builder: Builder) {
    /**
     * The language code that represents the language of the entries in your vocabulary filter. Each vocabulary filter must contain terms in only one language.
     *
     * A vocabulary filter can only be used to transcribe files in the same language as the filter. For example, if you create a vocabulary filter using US English (`en-US`), you can only apply this filter to files that contain English audio.
     *
     * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     */
    val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to a new custom vocabulary filter at the time you create this new filter.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt`
     *
     * Note that if you include `VocabularyFilterFileUri` in your request, you cannot use `Words`; you must choose one or the other.
     */
    val vocabularyFilterFileUri: kotlin.String? = builder.vocabularyFilterFileUri
    /**
     * A unique name, chosen by you, for your new custom vocabulary filter.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new vocabulary filter with the same name as an existing vocabulary filter, you get a `ConflictException` error.
     */
    val vocabularyFilterName: kotlin.String? = requireNotNull(builder.vocabularyFilterName) { "A non-null value must be provided for vocabularyFilterName" }
    /**
     * Use this parameter if you want to create your vocabulary filter by including all desired terms, as comma-separated values, within your request. The other option for creating your vocabulary filter is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the `VocabularyFilterFileUri` parameter.
     *
     * Note that if you include `Words` in your request, you cannot use `VocabularyFilterFileUri`; you must choose one or the other.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     */
    val words: List<String>? = builder.words

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVocabularyFilterRequest(")
        append("languageCode=$languageCode,")
        append("tags=$tags,")
        append("vocabularyFilterFileUri=$vocabularyFilterFileUri,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("words=$words)")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterFileUri?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (words?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVocabularyFilterRequest

        if (languageCode != other.languageCode) return false
        if (tags != other.tags) return false
        if (vocabularyFilterFileUri != other.vocabularyFilterFileUri) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (words != other.words) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code that represents the language of the entries in your vocabulary filter. Each vocabulary filter must contain terms in only one language.
         *
         * A vocabulary filter can only be used to transcribe files in the same language as the filter. For example, if you create a vocabulary filter using US English (`en-US`), you can only apply this filter to files that contain English audio.
         *
         * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         */
        var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to a new custom vocabulary filter at the time you create this new filter.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        var tags: List<Tag>? = null
        /**
         * The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt`
         *
         * Note that if you include `VocabularyFilterFileUri` in your request, you cannot use `Words`; you must choose one or the other.
         */
        var vocabularyFilterFileUri: kotlin.String? = null
        /**
         * A unique name, chosen by you, for your new custom vocabulary filter.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new vocabulary filter with the same name as an existing vocabulary filter, you get a `ConflictException` error.
         */
        var vocabularyFilterName: kotlin.String? = null
        /**
         * Use this parameter if you want to create your vocabulary filter by including all desired terms, as comma-separated values, within your request. The other option for creating your vocabulary filter is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the `VocabularyFilterFileUri` parameter.
         *
         * Note that if you include `Words` in your request, you cannot use `VocabularyFilterFileUri`; you must choose one or the other.
         *
         * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
         */
        var words: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest) : this() {
            this.languageCode = x.languageCode
            this.tags = x.tags
            this.vocabularyFilterFileUri = x.vocabularyFilterFileUri
            this.vocabularyFilterName = x.vocabularyFilterName
            this.words = x.words
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest = CreateVocabularyFilterRequest(this)
    }
}
