// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Flag the presence or absence of interruptions in your Call Analytics transcription output.
 *
 * Rules using `InterruptionFilter` are designed to match:
 * + Instances where an agent interrupts a customer
 * + Instances where a customer interrupts an agent
 * + Either participant interrupting the other
 * + A lack of interruptions
 *
 * See [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) for usage examples.
 */
class InterruptionFilter private constructor(builder: Builder) {
    /**
     * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for an interruption. See for more detail.
     */
    val absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = builder.absoluteTimeRange
    /**
     * Set to `TRUE` to flag speech that does not contain interruptions. Set to `FALSE` to flag speech that contains interruptions.
     */
    val negate: kotlin.Boolean? = builder.negate
    /**
     * Specify the interrupter you want to flag. Omitting this parameter is equivalent to specifying both participants.
     */
    val participantRole: aws.sdk.kotlin.services.transcribe.model.ParticipantRole? = builder.participantRole
    /**
     * Allows you to specify a time range (in percentage) in your media file, during which you want to search for an interruption. See for more detail.
     */
    val relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = builder.relativeTimeRange
    /**
     * Specify the duration of the interruptions in milliseconds. For example, you can flag speech that contains more than 10000 milliseconds of interruptions.
     */
    val threshold: kotlin.Long? = builder.threshold

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.InterruptionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InterruptionFilter(")
        append("absoluteTimeRange=$absoluteTimeRange,")
        append("negate=$negate,")
        append("participantRole=$participantRole,")
        append("relativeTimeRange=$relativeTimeRange,")
        append("threshold=$threshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = absoluteTimeRange?.hashCode() ?: 0
        result = 31 * result + (negate?.hashCode() ?: 0)
        result = 31 * result + (participantRole?.hashCode() ?: 0)
        result = 31 * result + (relativeTimeRange?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InterruptionFilter

        if (absoluteTimeRange != other.absoluteTimeRange) return false
        if (negate != other.negate) return false
        if (participantRole != other.participantRole) return false
        if (relativeTimeRange != other.relativeTimeRange) return false
        if (threshold != other.threshold) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.InterruptionFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for an interruption. See for more detail.
         */
        var absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = null
        /**
         * Set to `TRUE` to flag speech that does not contain interruptions. Set to `FALSE` to flag speech that contains interruptions.
         */
        var negate: kotlin.Boolean? = null
        /**
         * Specify the interrupter you want to flag. Omitting this parameter is equivalent to specifying both participants.
         */
        var participantRole: aws.sdk.kotlin.services.transcribe.model.ParticipantRole? = null
        /**
         * Allows you to specify a time range (in percentage) in your media file, during which you want to search for an interruption. See for more detail.
         */
        var relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = null
        /**
         * Specify the duration of the interruptions in milliseconds. For example, you can flag speech that contains more than 10000 milliseconds of interruptions.
         */
        var threshold: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.InterruptionFilter) : this() {
            this.absoluteTimeRange = x.absoluteTimeRange
            this.negate = x.negate
            this.participantRole = x.participantRole
            this.relativeTimeRange = x.relativeTimeRange
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.InterruptionFilter = InterruptionFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange] inside the given [block]
         */
        fun absoluteTimeRange(block: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.Builder.() -> kotlin.Unit) {
            this.absoluteTimeRange = aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange] inside the given [block]
         */
        fun relativeTimeRange(block: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.Builder.() -> kotlin.Unit) {
            this.relativeTimeRange = aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.invoke(block)
        }
    }
}
