// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Provides the name of the custom language model that was included in the specified transcription job.
 *
 * Only use `ModelSettings` with the `LanguageModelName` sub-parameter if you're **not** using automatic language identification (``). If using `LanguageIdSettings` in your request, this parameter contains a `LanguageModelName` sub-parameter.
 */
class ModelSettings private constructor(builder: Builder) {
    /**
     * The name of the custom language model you want to use when processing your transcription job. Note that language model names are case sensitive.
     *
     * The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the language model isn't applied. There are no errors or warnings associated with a language mismatch.
     */
    val languageModelName: kotlin.String? = builder.languageModelName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.ModelSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelSettings(")
        append("languageModelName=$languageModelName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageModelName?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelSettings

        if (languageModelName != other.languageModelName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.ModelSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the custom language model you want to use when processing your transcription job. Note that language model names are case sensitive.
         *
         * The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the language model isn't applied. There are no errors or warnings associated with a language mismatch.
         */
        var languageModelName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.ModelSettings) : this() {
            this.languageModelName = x.languageModelName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.ModelSettings = ModelSettings(this)
    }
}
