// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



class UpdateMedicalVocabularyRequest private constructor(builder: Builder) {
    /**
     * The language code that represents the language of the entries in the custom vocabulary you want to update. US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
     */
    val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * The Amazon S3 location of the text file that contains your custom medical vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
     */
    val vocabularyFileUri: kotlin.String? = builder.vocabularyFileUri
    /**
     * The name of the custom medical vocabulary you want to update. Vocabulary names are case sensitive.
     */
    val vocabularyName: kotlin.String? = requireNotNull(builder.vocabularyName) { "A non-null value must be provided for vocabularyName" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMedicalVocabularyRequest(")
        append("languageCode=$languageCode,")
        append("vocabularyFileUri=$vocabularyFileUri,")
        append("vocabularyName=$vocabularyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (vocabularyFileUri?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMedicalVocabularyRequest

        if (languageCode != other.languageCode) return false
        if (vocabularyFileUri != other.vocabularyFileUri) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code that represents the language of the entries in the custom vocabulary you want to update. US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
         */
        var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * The Amazon S3 location of the text file that contains your custom medical vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
         */
        var vocabularyFileUri: kotlin.String? = null
        /**
         * The name of the custom medical vocabulary you want to update. Vocabulary names are case sensitive.
         */
        var vocabularyName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest) : this() {
            this.languageCode = x.languageCode
            this.vocabularyFileUri = x.vocabularyFileUri
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest = UpdateMedicalVocabularyRequest(this)
    }
}
