// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus
import aws.sdk.kotlin.services.transcribe.model.TranscriptionJobSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListTranscriptionJobsOperationDeserializer: HttpDeserialize<ListTranscriptionJobsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTranscriptionJobsResponse {
        if (!response.status.isSuccess()) {
            throwListTranscriptionJobsError(context, response)
        }
        val builder = ListTranscriptionJobsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTranscriptionJobsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTranscriptionJobsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTranscriptionJobsOperationBody(builder: ListTranscriptionJobsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TranscriptionJobSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TranscriptionJobStatus.fromValue(it) }
                TRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR.index -> builder.transcriptionJobSummaries =
                    deserializer.deserializeList(TRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<TranscriptionJobSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTranscriptionJobSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
