// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJob
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartMedicalTranscriptionJobOperationDeserializer: HttpDeserialize<StartMedicalTranscriptionJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartMedicalTranscriptionJobResponse {
        if (!response.status.isSuccess()) {
            throwStartMedicalTranscriptionJobError(context, response)
        }
        val builder = StartMedicalTranscriptionJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartMedicalTranscriptionJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartMedicalTranscriptionJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartMedicalTranscriptionJobOperationBody(builder: StartMedicalTranscriptionJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEDICALTRANSCRIPTIONJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MedicalTranscriptionJob"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEDICALTRANSCRIPTIONJOB_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEDICALTRANSCRIPTIONJOB_DESCRIPTOR.index -> builder.medicalTranscriptionJob = deserializeMedicalTranscriptionJobDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
