// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transcribe.model.LanguageCode
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.VocabularyState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateVocabularyOperationDeserializer: HttpDeserialize<UpdateVocabularyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateVocabularyResponse {
        if (!response.status.isSuccess()) {
            throwUpdateVocabularyError(context, response)
        }
        val builder = UpdateVocabularyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateVocabularyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateVocabularyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateVocabularyOperationBody(builder: UpdateVocabularyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LanguageCode"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val VOCABULARYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VocabularyName"))
    val VOCABULARYSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VocabularyState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LANGUAGECODE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(VOCABULARYNAME_DESCRIPTOR)
        field(VOCABULARYSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LANGUAGECODE_DESCRIPTOR.index -> builder.languageCode = deserializeString().let { LanguageCode.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                VOCABULARYNAME_DESCRIPTOR.index -> builder.vocabularyName = deserializeString()
                VOCABULARYSTATE_DESCRIPTOR.index -> builder.vocabularyState = deserializeString().let { VocabularyState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
