// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.transfer.model.*
import aws.sdk.kotlin.services.transfer.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Transfer"
public const val ServiceApiVersion: String = "2018-11-05"
public const val SdkVersion: String = "0.17.5-beta"

internal class DefaultTransferClient(override val config: TransferClient.Config) : TransferClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use `CreateAccess` to limit the access to the correct set of users who need this ability.
     */
    override suspend fun createAccess(input: CreateAccessRequest): CreateAccessResponse {
        val op = SdkHttpOperation.build<CreateAccessRequest, CreateAccessResponse> {
            serializer = CreateAccessOperationSerializer()
            deserializer = CreateAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer Family server and an AS2 process. The agreement defines the file and message transfer relationship between the server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner profile, certificate, and other attributes.
     *
     * The partner is identified with the `PartnerProfileId`, and the AS2 process is identified with the `LocalProfileId`.
     */
    override suspend fun createAgreement(input: CreateAgreementRequest): CreateAgreementResponse {
        val op = SdkHttpOperation.build<CreateAgreementRequest, CreateAgreementResponse> {
            serializer = CreateAgreementOperationSerializer()
            deserializer = CreateAgreementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAgreement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the connector, which captures the parameters for an outbound connection for the AS2 protocol. The connector is required for sending files from a customer's non Amazon Web Services server.
     */
    override suspend fun createConnector(input: CreateConnectorRequest): CreateConnectorResponse {
        val op = SdkHttpOperation.build<CreateConnectorRequest, CreateConnectorResponse> {
            serializer = CreateConnectorOperationSerializer()
            deserializer = CreateConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the profile for the AS2 process. The agreement is between the partner and the AS2 process.
     */
    override suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse {
        val op = SdkHttpOperation.build<CreateProfileRequest, CreateProfileResponse> {
            serializer = CreateProfileOperationSerializer()
            deserializer = CreateProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated `ServerId` property that is assigned to the newly created server.
     */
    override suspend fun createServer(input: CreateServerRequest): CreateServerResponse {
        val op = SdkHttpOperation.build<CreateServerRequest, CreateServerResponse> {
            serializer = CreateServerOperationSerializer()
            deserializer = CreateServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the `IdentityProviderType` set to `SERVICE_MANAGED`. Using parameters for `CreateUser`, you can specify the user name, set the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the `workflow-details` field in `CreateServer` and `UpdateServer` operations.
     */
    override suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse {
        val op = SdkHttpOperation.build<CreateWorkflowRequest, CreateWorkflowResponse> {
            serializer = CreateWorkflowOperationSerializer()
            deserializer = CreateWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to delete the access specified in the `ServerID` and `ExternalID` parameters.
     */
    override suspend fun deleteAccess(input: DeleteAccessRequest): DeleteAccessResponse {
        val op = SdkHttpOperation.build<DeleteAccessRequest, DeleteAccessResponse> {
            serializer = DeleteAccessOperationSerializer()
            deserializer = DeleteAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete the agreement that's specified in the provided `AgreementId`.
     */
    override suspend fun deleteAgreement(input: DeleteAgreementRequest): DeleteAgreementResponse {
        val op = SdkHttpOperation.build<DeleteAgreementRequest, DeleteAgreementResponse> {
            serializer = DeleteAgreementOperationSerializer()
            deserializer = DeleteAgreementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAgreement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the certificate that's specified in the `CertificateId` parameter.
     */
    override suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCertificateRequest, DeleteCertificateResponse> {
            serializer = DeleteCertificateOperationSerializer()
            deserializer = DeleteCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the agreement that's specified in the provided `ConnectorId`.
     */
    override suspend fun deleteConnector(input: DeleteConnectorRequest): DeleteConnectorResponse {
        val op = SdkHttpOperation.build<DeleteConnectorRequest, DeleteConnectorResponse> {
            serializer = DeleteConnectorOperationSerializer()
            deserializer = DeleteConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the profile that's specified in the `ProfileId` parameter.
     */
    override suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse {
        val op = SdkHttpOperation.build<DeleteProfileRequest, DeleteProfileResponse> {
            serializer = DeleteProfileOperationSerializer()
            deserializer = DeleteProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the file transfer protocol-enabled server that you specify.
     *
     * No response returns from this operation.
     */
    override suspend fun deleteServer(input: DeleteServerRequest): DeleteServerResponse {
        val op = SdkHttpOperation.build<DeleteServerRequest, DeleteServerResponse> {
            serializer = DeleteServerOperationSerializer()
            deserializer = DeleteServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user's Secure Shell (SSH) public key.
     */
    override suspend fun deleteSshPublicKey(input: DeleteSshPublicKeyRequest): DeleteSshPublicKeyResponse {
        val op = SdkHttpOperation.build<DeleteSshPublicKeyRequest, DeleteSshPublicKeyResponse> {
            serializer = DeleteSshPublicKeyOperationSerializer()
            deserializer = DeleteSshPublicKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSshPublicKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     *
     * No response returns from this operation.
     *
     * When you delete a user from a server, the user's information is lost.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified workflow.
     */
    override suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowRequest, DeleteWorkflowResponse> {
            serializer = DeleteWorkflowOperationSerializer()
            deserializer = DeleteWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property and its `ExternalId`.
     *
     * The response from this call returns the properties of the access that is associated with the `ServerId` value that was specified.
     */
    override suspend fun describeAccess(input: DescribeAccessRequest): DescribeAccessResponse {
        val op = SdkHttpOperation.build<DescribeAccessRequest, DescribeAccessResponse> {
            serializer = DescribeAccessOperationSerializer()
            deserializer = DescribeAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the agreement that's identified by the `AgreementId`.
     */
    override suspend fun describeAgreement(input: DescribeAgreementRequest): DescribeAgreementResponse {
        val op = SdkHttpOperation.build<DescribeAgreementRequest, DescribeAgreementResponse> {
            serializer = DescribeAgreementOperationSerializer()
            deserializer = DescribeAgreementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAgreement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the certificate that's identified by the `CertificateId`.
     */
    override suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse {
        val op = SdkHttpOperation.build<DescribeCertificateRequest, DescribeCertificateResponse> {
            serializer = DescribeCertificateOperationSerializer()
            deserializer = DescribeCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the connector that's identified by the `ConnectorId.`
     */
    override suspend fun describeConnector(input: DescribeConnectorRequest): DescribeConnectorResponse {
        val op = SdkHttpOperation.build<DescribeConnectorRequest, DescribeConnectorResponse> {
            serializer = DescribeConnectorOperationSerializer()
            deserializer = DescribeConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * You can use `DescribeExecution` to check the details of the execution of the specified workflow.
     */
    override suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse {
        val op = SdkHttpOperation.build<DescribeExecutionRequest, DescribeExecutionResponse> {
            serializer = DescribeExecutionOperationSerializer()
            deserializer = DescribeExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of the profile that's specified by the `ProfileId`.
     */
    override suspend fun describeProfile(input: DescribeProfileRequest): DescribeProfileResponse {
        val op = SdkHttpOperation.build<DescribeProfileRequest, DescribeProfileResponse> {
            serializer = DescribeProfileOperationSerializer()
            deserializer = DescribeProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see [Working with security policies](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
     */
    override suspend fun describeSecurityPolicy(input: DescribeSecurityPolicyRequest): DescribeSecurityPolicyResponse {
        val op = SdkHttpOperation.build<DescribeSecurityPolicyRequest, DescribeSecurityPolicyResponse> {
            serializer = DescribeSecurityPolicyOperationSerializer()
            deserializer = DescribeSecurityPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSecurityPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
     *
     * The response contains a description of a server's properties. When you set `EndpointType` to VPC, the response will contain the `EndpointDetails`.
     */
    override suspend fun describeServer(input: DescribeServerRequest): DescribeServerResponse {
        val op = SdkHttpOperation.build<DescribeServerRequest, DescribeServerResponse> {
            serializer = DescribeServerOperationSerializer()
            deserializer = DescribeServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property.
     *
     * The response from this call returns the properties of the user associated with the `ServerId` value that was specified.
     */
    override suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse {
        val op = SdkHttpOperation.build<DescribeUserRequest, DescribeUserResponse> {
            serializer = DescribeUserOperationSerializer()
            deserializer = DescribeUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified workflow.
     */
    override suspend fun describeWorkflow(input: DescribeWorkflowRequest): DescribeWorkflowResponse {
        val op = SdkHttpOperation.build<DescribeWorkflowRequest, DescribeWorkflowResponse> {
            serializer = DescribeWorkflowOperationSerializer()
            deserializer = DescribeWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner profiles.
     */
    override suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse {
        val op = SdkHttpOperation.build<ImportCertificateRequest, ImportCertificateResponse> {
            serializer = ImportCertificateOperationSerializer()
            deserializer = ImportCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a Secure Shell (SSH) public key to a user account identified by a `UserName` value assigned to the specific file transfer protocol-enabled server, identified by `ServerId`.
     *
     * The response returns the `UserName` value, the `ServerId` value, and the name of the `SshPublicKeyId`.
     */
    override suspend fun importSshPublicKey(input: ImportSshPublicKeyRequest): ImportSshPublicKeyResponse {
        val op = SdkHttpOperation.build<ImportSshPublicKeyRequest, ImportSshPublicKeyResponse> {
            serializer = ImportSshPublicKeyOperationSerializer()
            deserializer = ImportSshPublicKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportSshPublicKey"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the details for all the accesses you have on your server.
     */
    override suspend fun listAccesses(input: ListAccessesRequest): ListAccessesResponse {
        val op = SdkHttpOperation.build<ListAccessesRequest, ListAccessesResponse> {
            serializer = ListAccessesOperationSerializer()
            deserializer = ListAccessesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccesses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the agreements for the server that's identified by the `ServerId` that you supply. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for `NextToken`, you can supply that value to continue listing agreements from where you left off.
     */
    override suspend fun listAgreements(input: ListAgreementsRequest): ListAgreementsResponse {
        val op = SdkHttpOperation.build<ListAgreementsRequest, ListAgreementsResponse> {
            serializer = ListAgreementsOperationSerializer()
            deserializer = ListAgreementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAgreements"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for the `NextToken` parameter, you can supply that value to continue listing certificates from where you left off.
     */
    override suspend fun listCertificates(input: ListCertificatesRequest): ListCertificatesResponse {
        val op = SdkHttpOperation.build<ListCertificatesRequest, ListCertificatesResponse> {
            serializer = ListCertificatesOperationSerializer()
            deserializer = ListCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the connectors for the specified Region.
     */
    override suspend fun listConnectors(input: ListConnectorsRequest): ListConnectorsResponse {
        val op = SdkHttpOperation.build<ListConnectorsRequest, ListConnectorsResponse> {
            serializer = ListConnectorsOperationSerializer()
            deserializer = ListConnectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConnectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all executions for the specified workflow.
     */
    override suspend fun listExecutions(input: ListExecutionsRequest): ListExecutionsResponse {
        val op = SdkHttpOperation.build<ListExecutionsRequest, ListExecutionsResponse> {
            serializer = ListExecutionsOperationSerializer()
            deserializer = ListExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for `NextToken`, you can supply that value to continue listing profiles from where you left off.
     */
    override suspend fun listProfiles(input: ListProfilesRequest): ListProfilesResponse {
        val op = SdkHttpOperation.build<ListProfilesRequest, ListProfilesResponse> {
            serializer = ListProfilesOperationSerializer()
            deserializer = ListProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     */
    override suspend fun listSecurityPolicies(input: ListSecurityPoliciesRequest): ListSecurityPoliciesResponse {
        val op = SdkHttpOperation.build<ListSecurityPoliciesRequest, ListSecurityPoliciesResponse> {
            serializer = ListSecurityPoliciesOperationSerializer()
            deserializer = ListSecurityPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSecurityPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     */
    override suspend fun listServers(input: ListServersRequest): ListServersResponse {
        val op = SdkHttpOperation.build<ListServersRequest, ListServersResponse> {
            serializer = ListServersOperationSerializer()
            deserializer = ListServersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of your workflows.
     */
    override suspend fun listWorkflows(input: ListWorkflowsRequest): ListWorkflowsResponse {
        val op = SdkHttpOperation.build<ListWorkflowsRequest, ListWorkflowsResponse> {
            serializer = ListWorkflowsOperationSerializer()
            deserializer = ListWorkflowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkflows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends a callback for asynchronous custom steps.
     *
     *  The `ExecutionId`, `WorkflowId`, and `Token` are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status.
     */
    override suspend fun sendWorkflowStepState(input: SendWorkflowStepStateRequest): SendWorkflowStepStateResponse {
        val op = SdkHttpOperation.build<SendWorkflowStepStateRequest, SendWorkflowStepStateResponse> {
            serializer = SendWorkflowStepStateOperationSerializer()
            deserializer = SendWorkflowStepStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendWorkflowStepState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Begins an outbound file transfer. You specify the `ConnectorId` and the file paths for where to send the files.
     */
    override suspend fun startFileTransfer(input: StartFileTransferRequest): StartFileTransferResponse {
        val op = SdkHttpOperation.build<StartFileTransferRequest, StartFileTransferResponse> {
            serializer = StartFileTransferOperationSerializer()
            deserializer = StartFileTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartFileTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the state of a file transfer protocol-enabled server from `OFFLINE` to `ONLINE`. It has no impact on a server that is already `ONLINE`. An `ONLINE` server can accept and process file transfer jobs.
     *
     * The state of `STARTING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of `START_FAILED` can indicate an error condition.
     *
     * No response is returned from this call.
     */
    override suspend fun startServer(input: StartServerRequest): StartServerResponse {
        val op = SdkHttpOperation.build<StartServerRequest, StartServerResponse> {
            serializer = StartServerOperationSerializer()
            deserializer = StartServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the state of a file transfer protocol-enabled server from `ONLINE` to `OFFLINE`. An `OFFLINE` server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.
     *
     * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.
     *
     * The state of `STOPPING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `STOP_FAILED` can indicate an error condition.
     *
     * No response is returned from this call.
     */
    override suspend fun stopServer(input: StopServerRequest): StopServerResponse {
        val op = SdkHttpOperation.build<StopServerRequest, StopServerResponse> {
            serializer = StopServerOperationSerializer()
            deserializer = StopServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
     *
     * There is no response returned from this call.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If the `IdentityProviderType` of a file transfer protocol-enabled server is `AWS_DIRECTORY_SERVICE` or `API_Gateway`, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.
     *
     *  The `ServerId` and `UserName` parameters are required. The `ServerProtocol`, `SourceIp`, and `UserPassword` are all optional.
     *
     *  You cannot use `TestIdentityProvider` if the `IdentityProviderType` of your server is `SERVICE_MANAGED`.
     *
     * +  If you provide any incorrect values for any parameters, the `Response` field is empty.
     * +  If you provide a server ID for a server that uses service-managed users, you get an error: ` An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth `
     * +  If you enter a Server ID for the `--server-id` parameter that does not identify an actual Transfer server, you receive the following error: `An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server`
     */
    override suspend fun testIdentityProvider(input: TestIdentityProviderRequest): TestIdentityProviderResponse {
        val op = SdkHttpOperation.build<TestIdentityProviderRequest, TestIdentityProviderResponse> {
            serializer = TestIdentityProviderOperationSerializer()
            deserializer = TestIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
     *
     * No response is returned from this call.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to update parameters for the access specified in the `ServerID` and `ExternalID` parameters.
     */
    override suspend fun updateAccess(input: UpdateAccessRequest): UpdateAccessResponse {
        val op = SdkHttpOperation.build<UpdateAccessRequest, UpdateAccessResponse> {
            serializer = UpdateAccessOperationSerializer()
            deserializer = UpdateAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some of the parameters for an existing agreement. Provide the `AgreementId` and the `ServerId` for the agreement that you want to update, along with the new values for the parameters to update.
     */
    override suspend fun updateAgreement(input: UpdateAgreementRequest): UpdateAgreementResponse {
        val op = SdkHttpOperation.build<UpdateAgreementRequest, UpdateAgreementResponse> {
            serializer = UpdateAgreementOperationSerializer()
            deserializer = UpdateAgreementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAgreement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the active and inactive dates for a certificate.
     */
    override suspend fun updateCertificate(input: UpdateCertificateRequest): UpdateCertificateResponse {
        val op = SdkHttpOperation.build<UpdateCertificateRequest, UpdateCertificateResponse> {
            serializer = UpdateCertificateOperationSerializer()
            deserializer = UpdateCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some of the parameters for an existing connector. Provide the `ConnectorId` for the connector that you want to update, along with the new values for the parameters to update.
     */
    override suspend fun updateConnector(input: UpdateConnectorRequest): UpdateConnectorResponse {
        val op = SdkHttpOperation.build<UpdateConnectorRequest, UpdateConnectorResponse> {
            serializer = UpdateConnectorOperationSerializer()
            deserializer = UpdateConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates some of the parameters for an existing profile. Provide the `ProfileId` for the profile that you want to update, along with the new values for the parameters to update.
     */
    override suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse {
        val op = SdkHttpOperation.build<UpdateProfileRequest, UpdateProfileResponse> {
            serializer = UpdateProfileOperationSerializer()
            deserializer = UpdateProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     *
     * The `UpdateServer` call returns the `ServerId` of the server you updated.
     */
    override suspend fun updateServer(input: UpdateServerRequest): UpdateServerResponse {
        val op = SdkHttpOperation.build<UpdateServerRequest, UpdateServerResponse> {
            serializer = UpdateServerOperationSerializer()
            deserializer = UpdateServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the `UserName` and `ServerId` you specify.
     *
     * The response returns the `ServerId` and the `UserName` for the updated user.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializer = UpdateUserOperationSerializer()
            deserializer = UpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("TransferService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "transfer"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "transfer")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
