// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.transfer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.transfer.model.*
import aws.sdk.kotlin.services.transfer.model.CreateAccessRequest
import aws.sdk.kotlin.services.transfer.model.CreateAccessResponse
import aws.sdk.kotlin.services.transfer.model.CreateAgreementRequest
import aws.sdk.kotlin.services.transfer.model.CreateAgreementResponse
import aws.sdk.kotlin.services.transfer.model.CreateConnectorRequest
import aws.sdk.kotlin.services.transfer.model.CreateConnectorResponse
import aws.sdk.kotlin.services.transfer.model.CreateProfileRequest
import aws.sdk.kotlin.services.transfer.model.CreateProfileResponse
import aws.sdk.kotlin.services.transfer.model.CreateServerRequest
import aws.sdk.kotlin.services.transfer.model.CreateServerResponse
import aws.sdk.kotlin.services.transfer.model.CreateUserRequest
import aws.sdk.kotlin.services.transfer.model.CreateUserResponse
import aws.sdk.kotlin.services.transfer.model.CreateWorkflowRequest
import aws.sdk.kotlin.services.transfer.model.CreateWorkflowResponse
import aws.sdk.kotlin.services.transfer.model.DeleteAccessRequest
import aws.sdk.kotlin.services.transfer.model.DeleteAccessResponse
import aws.sdk.kotlin.services.transfer.model.DeleteAgreementRequest
import aws.sdk.kotlin.services.transfer.model.DeleteAgreementResponse
import aws.sdk.kotlin.services.transfer.model.DeleteCertificateRequest
import aws.sdk.kotlin.services.transfer.model.DeleteCertificateResponse
import aws.sdk.kotlin.services.transfer.model.DeleteConnectorRequest
import aws.sdk.kotlin.services.transfer.model.DeleteConnectorResponse
import aws.sdk.kotlin.services.transfer.model.DeleteProfileRequest
import aws.sdk.kotlin.services.transfer.model.DeleteProfileResponse
import aws.sdk.kotlin.services.transfer.model.DeleteServerRequest
import aws.sdk.kotlin.services.transfer.model.DeleteServerResponse
import aws.sdk.kotlin.services.transfer.model.DeleteSshPublicKeyRequest
import aws.sdk.kotlin.services.transfer.model.DeleteSshPublicKeyResponse
import aws.sdk.kotlin.services.transfer.model.DeleteUserRequest
import aws.sdk.kotlin.services.transfer.model.DeleteUserResponse
import aws.sdk.kotlin.services.transfer.model.DeleteWorkflowRequest
import aws.sdk.kotlin.services.transfer.model.DeleteWorkflowResponse
import aws.sdk.kotlin.services.transfer.model.DescribeAccessRequest
import aws.sdk.kotlin.services.transfer.model.DescribeAccessResponse
import aws.sdk.kotlin.services.transfer.model.DescribeAgreementRequest
import aws.sdk.kotlin.services.transfer.model.DescribeAgreementResponse
import aws.sdk.kotlin.services.transfer.model.DescribeCertificateRequest
import aws.sdk.kotlin.services.transfer.model.DescribeCertificateResponse
import aws.sdk.kotlin.services.transfer.model.DescribeConnectorRequest
import aws.sdk.kotlin.services.transfer.model.DescribeConnectorResponse
import aws.sdk.kotlin.services.transfer.model.DescribeExecutionRequest
import aws.sdk.kotlin.services.transfer.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.transfer.model.DescribeProfileRequest
import aws.sdk.kotlin.services.transfer.model.DescribeProfileResponse
import aws.sdk.kotlin.services.transfer.model.DescribeSecurityPolicyRequest
import aws.sdk.kotlin.services.transfer.model.DescribeSecurityPolicyResponse
import aws.sdk.kotlin.services.transfer.model.DescribeServerRequest
import aws.sdk.kotlin.services.transfer.model.DescribeServerResponse
import aws.sdk.kotlin.services.transfer.model.DescribeUserRequest
import aws.sdk.kotlin.services.transfer.model.DescribeUserResponse
import aws.sdk.kotlin.services.transfer.model.DescribeWorkflowRequest
import aws.sdk.kotlin.services.transfer.model.DescribeWorkflowResponse
import aws.sdk.kotlin.services.transfer.model.ImportCertificateRequest
import aws.sdk.kotlin.services.transfer.model.ImportCertificateResponse
import aws.sdk.kotlin.services.transfer.model.ImportSshPublicKeyRequest
import aws.sdk.kotlin.services.transfer.model.ImportSshPublicKeyResponse
import aws.sdk.kotlin.services.transfer.model.ListAccessesRequest
import aws.sdk.kotlin.services.transfer.model.ListAccessesResponse
import aws.sdk.kotlin.services.transfer.model.ListAgreementsRequest
import aws.sdk.kotlin.services.transfer.model.ListAgreementsResponse
import aws.sdk.kotlin.services.transfer.model.ListCertificatesRequest
import aws.sdk.kotlin.services.transfer.model.ListCertificatesResponse
import aws.sdk.kotlin.services.transfer.model.ListConnectorsRequest
import aws.sdk.kotlin.services.transfer.model.ListConnectorsResponse
import aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest
import aws.sdk.kotlin.services.transfer.model.ListExecutionsResponse
import aws.sdk.kotlin.services.transfer.model.ListProfilesRequest
import aws.sdk.kotlin.services.transfer.model.ListProfilesResponse
import aws.sdk.kotlin.services.transfer.model.ListSecurityPoliciesRequest
import aws.sdk.kotlin.services.transfer.model.ListSecurityPoliciesResponse
import aws.sdk.kotlin.services.transfer.model.ListServersRequest
import aws.sdk.kotlin.services.transfer.model.ListServersResponse
import aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.transfer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.transfer.model.ListUsersRequest
import aws.sdk.kotlin.services.transfer.model.ListUsersResponse
import aws.sdk.kotlin.services.transfer.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.transfer.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.transfer.model.SendWorkflowStepStateRequest
import aws.sdk.kotlin.services.transfer.model.SendWorkflowStepStateResponse
import aws.sdk.kotlin.services.transfer.model.StartFileTransferRequest
import aws.sdk.kotlin.services.transfer.model.StartFileTransferResponse
import aws.sdk.kotlin.services.transfer.model.StartServerRequest
import aws.sdk.kotlin.services.transfer.model.StartServerResponse
import aws.sdk.kotlin.services.transfer.model.StopServerRequest
import aws.sdk.kotlin.services.transfer.model.StopServerResponse
import aws.sdk.kotlin.services.transfer.model.TagResourceRequest
import aws.sdk.kotlin.services.transfer.model.TagResourceResponse
import aws.sdk.kotlin.services.transfer.model.TestIdentityProviderRequest
import aws.sdk.kotlin.services.transfer.model.TestIdentityProviderResponse
import aws.sdk.kotlin.services.transfer.model.UntagResourceRequest
import aws.sdk.kotlin.services.transfer.model.UntagResourceResponse
import aws.sdk.kotlin.services.transfer.model.UpdateAccessRequest
import aws.sdk.kotlin.services.transfer.model.UpdateAccessResponse
import aws.sdk.kotlin.services.transfer.model.UpdateAgreementRequest
import aws.sdk.kotlin.services.transfer.model.UpdateAgreementResponse
import aws.sdk.kotlin.services.transfer.model.UpdateCertificateRequest
import aws.sdk.kotlin.services.transfer.model.UpdateCertificateResponse
import aws.sdk.kotlin.services.transfer.model.UpdateConnectorRequest
import aws.sdk.kotlin.services.transfer.model.UpdateConnectorResponse
import aws.sdk.kotlin.services.transfer.model.UpdateProfileRequest
import aws.sdk.kotlin.services.transfer.model.UpdateProfileResponse
import aws.sdk.kotlin.services.transfer.model.UpdateServerRequest
import aws.sdk.kotlin.services.transfer.model.UpdateServerResponse
import aws.sdk.kotlin.services.transfer.model.UpdateUserRequest
import aws.sdk.kotlin.services.transfer.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Transfer Family is a fully managed service that enables the transfer of files over the File Transfer Protocol (FTP), File Transfer Protocol over SSL (FTPS), or Secure Shell (SSH) File Transfer Protocol (SFTP) directly into and out of Amazon Simple Storage Service (Amazon S3). Amazon Web Services helps you seamlessly migrate your file transfer workflows to Transfer Family by integrating with existing authentication systems, and providing DNS routing with Amazon Route 53 so nothing changes for your customers and partners, or their applications. With your data in Amazon S3, you can use it with Amazon Web Services for processing, analytics, machine learning, and archiving. Getting started with Transfer Family is easy since there is no infrastructure to buy and set up.
 */
public interface TransferClient : SdkClient {

    override val serviceName: String
        get() = "Transfer"
    /**
     * TransferClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): TransferClient {
            val config = Config.Builder().apply(block).build()
            return DefaultTransferClient(config)
        }

        public operator fun invoke(config: Config): TransferClient = DefaultTransferClient(config)

        /**
         * Construct a [TransferClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): TransferClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultTransferClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use `CreateAccess` to limit the access to the correct set of users who need this ability.
     */
    public suspend fun createAccess(input: CreateAccessRequest): CreateAccessResponse

    /**
     * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer Family server and an AS2 process. The agreement defines the file and message transfer relationship between the server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner profile, certificate, and other attributes.
     *
     * The partner is identified with the `PartnerProfileId`, and the AS2 process is identified with the `LocalProfileId`.
     */
    public suspend fun createAgreement(input: CreateAgreementRequest): CreateAgreementResponse

    /**
     * Creates the connector, which captures the parameters for an outbound connection for the AS2 protocol. The connector is required for sending files from a customer's non Amazon Web Services server.
     */
    public suspend fun createConnector(input: CreateConnectorRequest): CreateConnectorResponse

    /**
     * Creates the profile for the AS2 process. The agreement is between the partner and the AS2 process.
     */
    public suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated `ServerId` property that is assigned to the newly created server.
     */
    public suspend fun createServer(input: CreateServerRequest = CreateServerRequest {}): CreateServerResponse

    /**
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the `IdentityProviderType` set to `SERVICE_MANAGED`. Using parameters for `CreateUser`, you can specify the user name, set the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the `workflow-details` field in `CreateServer` and `UpdateServer` operations.
     */
    public suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse

    /**
     * Allows you to delete the access specified in the `ServerID` and `ExternalID` parameters.
     */
    public suspend fun deleteAccess(input: DeleteAccessRequest): DeleteAccessResponse

    /**
     * Delete the agreement that's specified in the provided `AgreementId`.
     */
    public suspend fun deleteAgreement(input: DeleteAgreementRequest): DeleteAgreementResponse

    /**
     * Deletes the certificate that's specified in the `CertificateId` parameter.
     */
    public suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes the agreement that's specified in the provided `ConnectorId`.
     */
    public suspend fun deleteConnector(input: DeleteConnectorRequest): DeleteConnectorResponse

    /**
     * Deletes the profile that's specified in the `ProfileId` parameter.
     */
    public suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Deletes the file transfer protocol-enabled server that you specify.
     *
     * No response returns from this operation.
     */
    public suspend fun deleteServer(input: DeleteServerRequest): DeleteServerResponse

    /**
     * Deletes a user's Secure Shell (SSH) public key.
     */
    public suspend fun deleteSshPublicKey(input: DeleteSshPublicKeyRequest): DeleteSshPublicKeyResponse

    /**
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     *
     * No response returns from this operation.
     *
     * When you delete a user from a server, the user's information is lost.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes the specified workflow.
     */
    public suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property and its `ExternalId`.
     *
     * The response from this call returns the properties of the access that is associated with the `ServerId` value that was specified.
     */
    public suspend fun describeAccess(input: DescribeAccessRequest): DescribeAccessResponse

    /**
     * Describes the agreement that's identified by the `AgreementId`.
     */
    public suspend fun describeAgreement(input: DescribeAgreementRequest): DescribeAgreementResponse

    /**
     * Describes the certificate that's identified by the `CertificateId`.
     */
    public suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse

    /**
     * Describes the connector that's identified by the `ConnectorId.`
     */
    public suspend fun describeConnector(input: DescribeConnectorRequest): DescribeConnectorResponse

    /**
     * You can use `DescribeExecution` to check the details of the execution of the specified workflow.
     */
    public suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Returns the details of the profile that's specified by the `ProfileId`.
     */
    public suspend fun describeProfile(input: DescribeProfileRequest): DescribeProfileResponse

    /**
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see [Working with security policies](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
     */
    public suspend fun describeSecurityPolicy(input: DescribeSecurityPolicyRequest): DescribeSecurityPolicyResponse

    /**
     * Describes a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
     *
     * The response contains a description of a server's properties. When you set `EndpointType` to VPC, the response will contain the `EndpointDetails`.
     */
    public suspend fun describeServer(input: DescribeServerRequest): DescribeServerResponse

    /**
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property.
     *
     * The response from this call returns the properties of the user associated with the `ServerId` value that was specified.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Describes the specified workflow.
     */
    public suspend fun describeWorkflow(input: DescribeWorkflowRequest): DescribeWorkflowResponse

    /**
     * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner profiles.
     */
    public suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse

    /**
     * Adds a Secure Shell (SSH) public key to a user account identified by a `UserName` value assigned to the specific file transfer protocol-enabled server, identified by `ServerId`.
     *
     * The response returns the `UserName` value, the `ServerId` value, and the name of the `SshPublicKeyId`.
     */
    public suspend fun importSshPublicKey(input: ImportSshPublicKeyRequest): ImportSshPublicKeyResponse

    /**
     * Lists the details for all the accesses you have on your server.
     */
    public suspend fun listAccesses(input: ListAccessesRequest): ListAccessesResponse

    /**
     * Returns a list of the agreements for the server that's identified by the `ServerId` that you supply. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for `NextToken`, you can supply that value to continue listing agreements from where you left off.
     */
    public suspend fun listAgreements(input: ListAgreementsRequest): ListAgreementsResponse

    /**
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for the `NextToken` parameter, you can supply that value to continue listing certificates from where you left off.
     */
    public suspend fun listCertificates(input: ListCertificatesRequest = ListCertificatesRequest {}): ListCertificatesResponse

    /**
     * Lists the connectors for the specified Region.
     */
    public suspend fun listConnectors(input: ListConnectorsRequest = ListConnectorsRequest {}): ListConnectorsResponse

    /**
     * Lists all executions for the specified workflow.
     */
    public suspend fun listExecutions(input: ListExecutionsRequest): ListExecutionsResponse

    /**
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for `NextToken`, you can supply that value to continue listing profiles from where you left off.
     */
    public suspend fun listProfiles(input: ListProfilesRequest = ListProfilesRequest {}): ListProfilesResponse

    /**
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     */
    public suspend fun listSecurityPolicies(input: ListSecurityPoliciesRequest = ListSecurityPoliciesRequest {}): ListSecurityPoliciesResponse

    /**
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     */
    public suspend fun listServers(input: ListServersRequest = ListServersRequest {}): ListServersResponse

    /**
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists all of your workflows.
     */
    public suspend fun listWorkflows(input: ListWorkflowsRequest = ListWorkflowsRequest {}): ListWorkflowsResponse

    /**
     * Sends a callback for asynchronous custom steps.
     *
     *  The `ExecutionId`, `WorkflowId`, and `Token` are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status.
     */
    public suspend fun sendWorkflowStepState(input: SendWorkflowStepStateRequest): SendWorkflowStepStateResponse

    /**
     * Begins an outbound file transfer. You specify the `ConnectorId` and the file paths for where to send the files.
     */
    public suspend fun startFileTransfer(input: StartFileTransferRequest): StartFileTransferResponse

    /**
     * Changes the state of a file transfer protocol-enabled server from `OFFLINE` to `ONLINE`. It has no impact on a server that is already `ONLINE`. An `ONLINE` server can accept and process file transfer jobs.
     *
     * The state of `STARTING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of `START_FAILED` can indicate an error condition.
     *
     * No response is returned from this call.
     */
    public suspend fun startServer(input: StartServerRequest): StartServerResponse

    /**
     * Changes the state of a file transfer protocol-enabled server from `ONLINE` to `OFFLINE`. An `OFFLINE` server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.
     *
     * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.
     *
     * The state of `STOPPING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `STOP_FAILED` can indicate an error condition.
     *
     * No response is returned from this call.
     */
    public suspend fun stopServer(input: StopServerRequest): StopServerResponse

    /**
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
     *
     * There is no response returned from this call.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * If the `IdentityProviderType` of a file transfer protocol-enabled server is `AWS_DIRECTORY_SERVICE` or `API_Gateway`, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.
     *
     *  The `ServerId` and `UserName` parameters are required. The `ServerProtocol`, `SourceIp`, and `UserPassword` are all optional.
     *
     *  You cannot use `TestIdentityProvider` if the `IdentityProviderType` of your server is `SERVICE_MANAGED`.
     *
     * +  If you provide any incorrect values for any parameters, the `Response` field is empty.
     * +  If you provide a server ID for a server that uses service-managed users, you get an error: ` An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth `
     * +  If you enter a Server ID for the `--server-id` parameter that does not identify an actual Transfer server, you receive the following error: `An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server`
     */
    public suspend fun testIdentityProvider(input: TestIdentityProviderRequest): TestIdentityProviderResponse

    /**
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
     *
     * No response is returned from this call.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Allows you to update parameters for the access specified in the `ServerID` and `ExternalID` parameters.
     */
    public suspend fun updateAccess(input: UpdateAccessRequest): UpdateAccessResponse

    /**
     * Updates some of the parameters for an existing agreement. Provide the `AgreementId` and the `ServerId` for the agreement that you want to update, along with the new values for the parameters to update.
     */
    public suspend fun updateAgreement(input: UpdateAgreementRequest): UpdateAgreementResponse

    /**
     * Updates the active and inactive dates for a certificate.
     */
    public suspend fun updateCertificate(input: UpdateCertificateRequest): UpdateCertificateResponse

    /**
     * Updates some of the parameters for an existing connector. Provide the `ConnectorId` for the connector that you want to update, along with the new values for the parameters to update.
     */
    public suspend fun updateConnector(input: UpdateConnectorRequest): UpdateConnectorResponse

    /**
     * Updates some of the parameters for an existing profile. Provide the `ProfileId` for the profile that you want to update, along with the new values for the parameters to update.
     */
    public suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse

    /**
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     *
     * The `UpdateServer` call returns the `ServerId` of the server you updated.
     */
    public suspend fun updateServer(input: UpdateServerRequest): UpdateServerResponse

    /**
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the `UserName` and `ServerId` you specify.
     *
     * The response returns the `ServerId` and the `UserName` for the updated user.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use `CreateAccess` to limit the access to the correct set of users who need this ability.
 */
public suspend inline fun TransferClient.createAccess(crossinline block: CreateAccessRequest.Builder.() -> Unit): CreateAccessResponse = createAccess(CreateAccessRequest.Builder().apply(block).build())

/**
 * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer Family server and an AS2 process. The agreement defines the file and message transfer relationship between the server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner profile, certificate, and other attributes.
 *
 * The partner is identified with the `PartnerProfileId`, and the AS2 process is identified with the `LocalProfileId`.
 */
public suspend inline fun TransferClient.createAgreement(crossinline block: CreateAgreementRequest.Builder.() -> Unit): CreateAgreementResponse = createAgreement(CreateAgreementRequest.Builder().apply(block).build())

/**
 * Creates the connector, which captures the parameters for an outbound connection for the AS2 protocol. The connector is required for sending files from a customer's non Amazon Web Services server.
 */
public suspend inline fun TransferClient.createConnector(crossinline block: CreateConnectorRequest.Builder.() -> Unit): CreateConnectorResponse = createConnector(CreateConnectorRequest.Builder().apply(block).build())

/**
 * Creates the profile for the AS2 process. The agreement is between the partner and the AS2 process.
 */
public suspend inline fun TransferClient.createProfile(crossinline block: CreateProfileRequest.Builder.() -> Unit): CreateProfileResponse = createProfile(CreateProfileRequest.Builder().apply(block).build())

/**
 * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated `ServerId` property that is assigned to the newly created server.
 */
public suspend inline fun TransferClient.createServer(crossinline block: CreateServerRequest.Builder.() -> Unit): CreateServerResponse = createServer(CreateServerRequest.Builder().apply(block).build())

/**
 * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the `IdentityProviderType` set to `SERVICE_MANAGED`. Using parameters for `CreateUser`, you can specify the user name, set the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.
 */
public suspend inline fun TransferClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the `workflow-details` field in `CreateServer` and `UpdateServer` operations.
 */
public suspend inline fun TransferClient.createWorkflow(crossinline block: CreateWorkflowRequest.Builder.() -> Unit): CreateWorkflowResponse = createWorkflow(CreateWorkflowRequest.Builder().apply(block).build())

/**
 * Allows you to delete the access specified in the `ServerID` and `ExternalID` parameters.
 */
public suspend inline fun TransferClient.deleteAccess(crossinline block: DeleteAccessRequest.Builder.() -> Unit): DeleteAccessResponse = deleteAccess(DeleteAccessRequest.Builder().apply(block).build())

/**
 * Delete the agreement that's specified in the provided `AgreementId`.
 */
public suspend inline fun TransferClient.deleteAgreement(crossinline block: DeleteAgreementRequest.Builder.() -> Unit): DeleteAgreementResponse = deleteAgreement(DeleteAgreementRequest.Builder().apply(block).build())

/**
 * Deletes the certificate that's specified in the `CertificateId` parameter.
 */
public suspend inline fun TransferClient.deleteCertificate(crossinline block: DeleteCertificateRequest.Builder.() -> Unit): DeleteCertificateResponse = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

/**
 * Deletes the agreement that's specified in the provided `ConnectorId`.
 */
public suspend inline fun TransferClient.deleteConnector(crossinline block: DeleteConnectorRequest.Builder.() -> Unit): DeleteConnectorResponse = deleteConnector(DeleteConnectorRequest.Builder().apply(block).build())

/**
 * Deletes the profile that's specified in the `ProfileId` parameter.
 */
public suspend inline fun TransferClient.deleteProfile(crossinline block: DeleteProfileRequest.Builder.() -> Unit): DeleteProfileResponse = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

/**
 * Deletes the file transfer protocol-enabled server that you specify.
 *
 * No response returns from this operation.
 */
public suspend inline fun TransferClient.deleteServer(crossinline block: DeleteServerRequest.Builder.() -> Unit): DeleteServerResponse = deleteServer(DeleteServerRequest.Builder().apply(block).build())

/**
 * Deletes a user's Secure Shell (SSH) public key.
 */
public suspend inline fun TransferClient.deleteSshPublicKey(crossinline block: DeleteSshPublicKeyRequest.Builder.() -> Unit): DeleteSshPublicKeyResponse = deleteSshPublicKey(DeleteSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Deletes the user belonging to a file transfer protocol-enabled server you specify.
 *
 * No response returns from this operation.
 *
 * When you delete a user from a server, the user's information is lost.
 */
public suspend inline fun TransferClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes the specified workflow.
 */
public suspend inline fun TransferClient.deleteWorkflow(crossinline block: DeleteWorkflowRequest.Builder.() -> Unit): DeleteWorkflowResponse = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

/**
 * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property and its `ExternalId`.
 *
 * The response from this call returns the properties of the access that is associated with the `ServerId` value that was specified.
 */
public suspend inline fun TransferClient.describeAccess(crossinline block: DescribeAccessRequest.Builder.() -> Unit): DescribeAccessResponse = describeAccess(DescribeAccessRequest.Builder().apply(block).build())

/**
 * Describes the agreement that's identified by the `AgreementId`.
 */
public suspend inline fun TransferClient.describeAgreement(crossinline block: DescribeAgreementRequest.Builder.() -> Unit): DescribeAgreementResponse = describeAgreement(DescribeAgreementRequest.Builder().apply(block).build())

/**
 * Describes the certificate that's identified by the `CertificateId`.
 */
public suspend inline fun TransferClient.describeCertificate(crossinline block: DescribeCertificateRequest.Builder.() -> Unit): DescribeCertificateResponse = describeCertificate(DescribeCertificateRequest.Builder().apply(block).build())

/**
 * Describes the connector that's identified by the `ConnectorId.`
 */
public suspend inline fun TransferClient.describeConnector(crossinline block: DescribeConnectorRequest.Builder.() -> Unit): DescribeConnectorResponse = describeConnector(DescribeConnectorRequest.Builder().apply(block).build())

/**
 * You can use `DescribeExecution` to check the details of the execution of the specified workflow.
 */
public suspend inline fun TransferClient.describeExecution(crossinline block: DescribeExecutionRequest.Builder.() -> Unit): DescribeExecutionResponse = describeExecution(DescribeExecutionRequest.Builder().apply(block).build())

/**
 * Returns the details of the profile that's specified by the `ProfileId`.
 */
public suspend inline fun TransferClient.describeProfile(crossinline block: DescribeProfileRequest.Builder.() -> Unit): DescribeProfileResponse = describeProfile(DescribeProfileRequest.Builder().apply(block).build())

/**
 * Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see [Working with security policies](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
 */
public suspend inline fun TransferClient.describeSecurityPolicy(crossinline block: DescribeSecurityPolicyRequest.Builder.() -> Unit): DescribeSecurityPolicyResponse = describeSecurityPolicy(DescribeSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Describes a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
 *
 * The response contains a description of a server's properties. When you set `EndpointType` to VPC, the response will contain the `EndpointDetails`.
 */
public suspend inline fun TransferClient.describeServer(crossinline block: DescribeServerRequest.Builder.() -> Unit): DescribeServerResponse = describeServer(DescribeServerRequest.Builder().apply(block).build())

/**
 * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property.
 *
 * The response from this call returns the properties of the user associated with the `ServerId` value that was specified.
 */
public suspend inline fun TransferClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Describes the specified workflow.
 */
public suspend inline fun TransferClient.describeWorkflow(crossinline block: DescribeWorkflowRequest.Builder.() -> Unit): DescribeWorkflowResponse = describeWorkflow(DescribeWorkflowRequest.Builder().apply(block).build())

/**
 * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner profiles.
 */
public suspend inline fun TransferClient.importCertificate(crossinline block: ImportCertificateRequest.Builder.() -> Unit): ImportCertificateResponse = importCertificate(ImportCertificateRequest.Builder().apply(block).build())

/**
 * Adds a Secure Shell (SSH) public key to a user account identified by a `UserName` value assigned to the specific file transfer protocol-enabled server, identified by `ServerId`.
 *
 * The response returns the `UserName` value, the `ServerId` value, and the name of the `SshPublicKeyId`.
 */
public suspend inline fun TransferClient.importSshPublicKey(crossinline block: ImportSshPublicKeyRequest.Builder.() -> Unit): ImportSshPublicKeyResponse = importSshPublicKey(ImportSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Lists the details for all the accesses you have on your server.
 */
public suspend inline fun TransferClient.listAccesses(crossinline block: ListAccessesRequest.Builder.() -> Unit): ListAccessesResponse = listAccesses(ListAccessesRequest.Builder().apply(block).build())

/**
 * Returns a list of the agreements for the server that's identified by the `ServerId` that you supply. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for `NextToken`, you can supply that value to continue listing agreements from where you left off.
 */
public suspend inline fun TransferClient.listAgreements(crossinline block: ListAgreementsRequest.Builder.() -> Unit): ListAgreementsResponse = listAgreements(ListAgreementsRequest.Builder().apply(block).build())

/**
 * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for the `NextToken` parameter, you can supply that value to continue listing certificates from where you left off.
 */
public suspend inline fun TransferClient.listCertificates(crossinline block: ListCertificatesRequest.Builder.() -> Unit): ListCertificatesResponse = listCertificates(ListCertificatesRequest.Builder().apply(block).build())

/**
 * Lists the connectors for the specified Region.
 */
public suspend inline fun TransferClient.listConnectors(crossinline block: ListConnectorsRequest.Builder.() -> Unit): ListConnectorsResponse = listConnectors(ListConnectorsRequest.Builder().apply(block).build())

/**
 * Lists all executions for the specified workflow.
 */
public suspend inline fun TransferClient.listExecutions(crossinline block: ListExecutionsRequest.Builder.() -> Unit): ListExecutionsResponse = listExecutions(ListExecutionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a value for the `MaxResults` parameter. If you ran the command previously and received a value for `NextToken`, you can supply that value to continue listing profiles from where you left off.
 */
public suspend inline fun TransferClient.listProfiles(crossinline block: ListProfilesRequest.Builder.() -> Unit): ListProfilesResponse = listProfiles(ListProfilesRequest.Builder().apply(block).build())

/**
 * Lists the security policies that are attached to your file transfer protocol-enabled servers.
 */
public suspend inline fun TransferClient.listSecurityPolicies(crossinline block: ListSecurityPoliciesRequest.Builder.() -> Unit): ListSecurityPoliciesResponse = listSecurityPolicies(ListSecurityPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
 */
public suspend inline fun TransferClient.listServers(crossinline block: ListServersRequest.Builder.() -> Unit): ListServersResponse = listServers(ListServersRequest.Builder().apply(block).build())

/**
 * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.
 */
public suspend inline fun TransferClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the users for a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
 */
public suspend inline fun TransferClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Lists all of your workflows.
 */
public suspend inline fun TransferClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit): ListWorkflowsResponse = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Sends a callback for asynchronous custom steps.
 *
 *  The `ExecutionId`, `WorkflowId`, and `Token` are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status.
 */
public suspend inline fun TransferClient.sendWorkflowStepState(crossinline block: SendWorkflowStepStateRequest.Builder.() -> Unit): SendWorkflowStepStateResponse = sendWorkflowStepState(SendWorkflowStepStateRequest.Builder().apply(block).build())

/**
 * Begins an outbound file transfer. You specify the `ConnectorId` and the file paths for where to send the files.
 */
public suspend inline fun TransferClient.startFileTransfer(crossinline block: StartFileTransferRequest.Builder.() -> Unit): StartFileTransferResponse = startFileTransfer(StartFileTransferRequest.Builder().apply(block).build())

/**
 * Changes the state of a file transfer protocol-enabled server from `OFFLINE` to `ONLINE`. It has no impact on a server that is already `ONLINE`. An `ONLINE` server can accept and process file transfer jobs.
 *
 * The state of `STARTING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of `START_FAILED` can indicate an error condition.
 *
 * No response is returned from this call.
 */
public suspend inline fun TransferClient.startServer(crossinline block: StartServerRequest.Builder.() -> Unit): StartServerResponse = startServer(StartServerRequest.Builder().apply(block).build())

/**
 * Changes the state of a file transfer protocol-enabled server from `ONLINE` to `OFFLINE`. An `OFFLINE` server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.
 *
 * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.
 *
 * The state of `STOPPING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `STOP_FAILED` can indicate an error condition.
 *
 * No response is returned from this call.
 */
public suspend inline fun TransferClient.stopServer(crossinline block: StopServerRequest.Builder.() -> Unit): StopServerResponse = stopServer(StopServerRequest.Builder().apply(block).build())

/**
 * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
 *
 * There is no response returned from this call.
 */
public suspend inline fun TransferClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * If the `IdentityProviderType` of a file transfer protocol-enabled server is `AWS_DIRECTORY_SERVICE` or `API_Gateway`, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.
 *
 *  The `ServerId` and `UserName` parameters are required. The `ServerProtocol`, `SourceIp`, and `UserPassword` are all optional.
 *
 *  You cannot use `TestIdentityProvider` if the `IdentityProviderType` of your server is `SERVICE_MANAGED`.
 *
 * +  If you provide any incorrect values for any parameters, the `Response` field is empty.
 * +  If you provide a server ID for a server that uses service-managed users, you get an error: ` An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth `
 * +  If you enter a Server ID for the `--server-id` parameter that does not identify an actual Transfer server, you receive the following error: `An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server`
 */
public suspend inline fun TransferClient.testIdentityProvider(crossinline block: TestIdentityProviderRequest.Builder.() -> Unit): TestIdentityProviderResponse = testIdentityProvider(TestIdentityProviderRequest.Builder().apply(block).build())

/**
 * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
 *
 * No response is returned from this call.
 */
public suspend inline fun TransferClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Allows you to update parameters for the access specified in the `ServerID` and `ExternalID` parameters.
 */
public suspend inline fun TransferClient.updateAccess(crossinline block: UpdateAccessRequest.Builder.() -> Unit): UpdateAccessResponse = updateAccess(UpdateAccessRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters for an existing agreement. Provide the `AgreementId` and the `ServerId` for the agreement that you want to update, along with the new values for the parameters to update.
 */
public suspend inline fun TransferClient.updateAgreement(crossinline block: UpdateAgreementRequest.Builder.() -> Unit): UpdateAgreementResponse = updateAgreement(UpdateAgreementRequest.Builder().apply(block).build())

/**
 * Updates the active and inactive dates for a certificate.
 */
public suspend inline fun TransferClient.updateCertificate(crossinline block: UpdateCertificateRequest.Builder.() -> Unit): UpdateCertificateResponse = updateCertificate(UpdateCertificateRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters for an existing connector. Provide the `ConnectorId` for the connector that you want to update, along with the new values for the parameters to update.
 */
public suspend inline fun TransferClient.updateConnector(crossinline block: UpdateConnectorRequest.Builder.() -> Unit): UpdateConnectorResponse = updateConnector(UpdateConnectorRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters for an existing profile. Provide the `ProfileId` for the profile that you want to update, along with the new values for the parameters to update.
 */
public suspend inline fun TransferClient.updateProfile(crossinline block: UpdateProfileRequest.Builder.() -> Unit): UpdateProfileResponse = updateProfile(UpdateProfileRequest.Builder().apply(block).build())

/**
 * Updates the file transfer protocol-enabled server's properties after that server has been created.
 *
 * The `UpdateServer` call returns the `ServerId` of the server you updated.
 */
public suspend inline fun TransferClient.updateServer(crossinline block: UpdateServerRequest.Builder.() -> Unit): UpdateServerResponse = updateServer(UpdateServerRequest.Builder().apply(block).build())

/**
 * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the `UserName` and `ServerId` you specify.
 *
 * The response returns the `ServerId` and the `UserName` for the updated user.
 */
public suspend inline fun TransferClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
