// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Contains the details for a connector object. The connector object is used for AS2 outbound processes, to connect the Transfer Family customer with the trading partner.
 */
public class As2ConnectorConfig private constructor(builder: Builder) {
    /**
     * Specifies whether the AS2 file is compressed.
     */
    public val compression: aws.sdk.kotlin.services.transfer.model.CompressionEnum? = builder.compression
    /**
     * The algorithm that is used to encrypt the file.
     */
    public val encryptionAlgorithm: aws.sdk.kotlin.services.transfer.model.EncryptionAlg? = builder.encryptionAlgorithm
    /**
     * A unique identifier for the AS2 process.
     */
    public val localProfileId: kotlin.String? = builder.localProfileId
    /**
     * Used for outbound requests (from an Transfer Family server to a partner AS2 server) to determine whether the partner response for transfers is synchronous or asynchronous. Specify either of the following values:
     * + `SYNC`: The system expects a synchronous MDN response, confirming that the file was transferred successfully (or not).
     * + `NONE`: Specifies that no MDN response is required.
     */
    public val mdnResponse: aws.sdk.kotlin.services.transfer.model.MdnResponse? = builder.mdnResponse
    /**
     * The signing algorithm for the MDN response.
     */
    public val mdnSigningAlgorithm: aws.sdk.kotlin.services.transfer.model.MdnSigningAlg? = builder.mdnSigningAlgorithm
    /**
     * A short description to help identify the connector.
     */
    public val messageSubject: kotlin.String? = builder.messageSubject
    /**
     * A unique identifier for the partner for the connector.
     */
    public val partnerProfileId: kotlin.String? = builder.partnerProfileId
    /**
     * The algorithm that is used to sign the AS2 transfers for this partner profile.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.transfer.model.SigningAlg? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("As2ConnectorConfig(")
        append("compression=$compression,")
        append("encryptionAlgorithm=$encryptionAlgorithm,")
        append("localProfileId=$localProfileId,")
        append("mdnResponse=$mdnResponse,")
        append("mdnSigningAlgorithm=$mdnSigningAlgorithm,")
        append("messageSubject=$messageSubject,")
        append("partnerProfileId=$partnerProfileId,")
        append("signingAlgorithm=$signingAlgorithm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = compression?.hashCode() ?: 0
        result = 31 * result + (encryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (localProfileId?.hashCode() ?: 0)
        result = 31 * result + (mdnResponse?.hashCode() ?: 0)
        result = 31 * result + (mdnSigningAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (messageSubject?.hashCode() ?: 0)
        result = 31 * result + (partnerProfileId?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as As2ConnectorConfig

        if (compression != other.compression) return false
        if (encryptionAlgorithm != other.encryptionAlgorithm) return false
        if (localProfileId != other.localProfileId) return false
        if (mdnResponse != other.mdnResponse) return false
        if (mdnSigningAlgorithm != other.mdnSigningAlgorithm) return false
        if (messageSubject != other.messageSubject) return false
        if (partnerProfileId != other.partnerProfileId) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the AS2 file is compressed.
         */
        public var compression: aws.sdk.kotlin.services.transfer.model.CompressionEnum? = null
        /**
         * The algorithm that is used to encrypt the file.
         */
        public var encryptionAlgorithm: aws.sdk.kotlin.services.transfer.model.EncryptionAlg? = null
        /**
         * A unique identifier for the AS2 process.
         */
        public var localProfileId: kotlin.String? = null
        /**
         * Used for outbound requests (from an Transfer Family server to a partner AS2 server) to determine whether the partner response for transfers is synchronous or asynchronous. Specify either of the following values:
         * + `SYNC`: The system expects a synchronous MDN response, confirming that the file was transferred successfully (or not).
         * + `NONE`: Specifies that no MDN response is required.
         */
        public var mdnResponse: aws.sdk.kotlin.services.transfer.model.MdnResponse? = null
        /**
         * The signing algorithm for the MDN response.
         */
        public var mdnSigningAlgorithm: aws.sdk.kotlin.services.transfer.model.MdnSigningAlg? = null
        /**
         * A short description to help identify the connector.
         */
        public var messageSubject: kotlin.String? = null
        /**
         * A unique identifier for the partner for the connector.
         */
        public var partnerProfileId: kotlin.String? = null
        /**
         * The algorithm that is used to sign the AS2 transfers for this partner profile.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.transfer.model.SigningAlg? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig) : this() {
            this.compression = x.compression
            this.encryptionAlgorithm = x.encryptionAlgorithm
            this.localProfileId = x.localProfileId
            this.mdnResponse = x.mdnResponse
            this.mdnSigningAlgorithm = x.mdnSigningAlgorithm
            this.messageSubject = x.messageSubject
            this.partnerProfileId = x.partnerProfileId
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig = As2ConnectorConfig(this)
    }
}
