// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



public class CreateAccessRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.
     *
     * `Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid`
     *
     * In that command, replace *YourGroupName* with the name of your Active Directory group.
     *
     * The regular expression used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The landing directory (folder) for a user when they log in to the server using the client.
     *
     * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
     */
    public val homeDirectory: kotlin.String? = builder.homeDirectory
    /**
     * Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the `Entry` and `Target` pair, where `Entry` shows how the path is made visible and `Target` is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Identity and Access Management (IAM) role provides access to paths in `Target`. This value can be set only when `HomeDirectoryType` is set to *LOGICAL*.
     *
     * The following is an `Entry` and `Target` pair example.
     *
     * `[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]`
     *
     * In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("`chroot`"). To do this, you can set `Entry` to `/` and set `Target` to the `HomeDirectory` parameter value.
     *
     * The following is an `Entry` and `Target` pair example for `chroot`.
     *
     * `[ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]`
     */
    public val homeDirectoryMappings: List<HomeDirectoryMapEntry>? = builder.homeDirectoryMappings
    /**
     * The type of landing directory (folder) that you want your users' home directory to be when they log in to the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or Amazon EFS paths visible to your users.
     */
    public val homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = builder.homeDirectoryType
    /**
     * A session policy for your user so that you can use the same Identity and Access Management (IAM) role across multiple users. This policy scopes down a user's access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`.
     *
     * This policy applies only when the domain of `ServerId` is Amazon S3. Amazon EFS does not use session policies.
     *
     * For session policies, Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the `Policy` argument.
     *
     * For an example of a session policy, see [Example session policy](https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html).
     *
     * For more information, see [AssumeRole](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html) in the *Security Token Service API Reference*.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
     */
    public val posixProfile: aws.sdk.kotlin.services.transfer.model.PosixProfile? = builder.posixProfile
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
     */
    public val role: kotlin.String? = builder.role
    /**
     * A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.
     */
    public val serverId: kotlin.String? = builder.serverId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.CreateAccessRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessRequest(")
        append("externalId=$externalId,")
        append("homeDirectory=$homeDirectory,")
        append("homeDirectoryMappings=$homeDirectoryMappings,")
        append("homeDirectoryType=$homeDirectoryType,")
        append("policy=$policy,")
        append("posixProfile=$posixProfile,")
        append("role=$role,")
        append("serverId=$serverId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = externalId?.hashCode() ?: 0
        result = 31 * result + (homeDirectory?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryMappings?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryType?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (posixProfile?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (serverId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessRequest

        if (externalId != other.externalId) return false
        if (homeDirectory != other.homeDirectory) return false
        if (homeDirectoryMappings != other.homeDirectoryMappings) return false
        if (homeDirectoryType != other.homeDirectoryType) return false
        if (policy != other.policy) return false
        if (posixProfile != other.posixProfile) return false
        if (role != other.role) return false
        if (serverId != other.serverId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.CreateAccessRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.
         *
         * `Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid`
         *
         * In that command, replace *YourGroupName* with the name of your Active Directory group.
         *
         * The regular expression used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-
         */
        public var externalId: kotlin.String? = null
        /**
         * The landing directory (folder) for a user when they log in to the server using the client.
         *
         * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
         */
        public var homeDirectory: kotlin.String? = null
        /**
         * Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the `Entry` and `Target` pair, where `Entry` shows how the path is made visible and `Target` is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Identity and Access Management (IAM) role provides access to paths in `Target`. This value can be set only when `HomeDirectoryType` is set to *LOGICAL*.
         *
         * The following is an `Entry` and `Target` pair example.
         *
         * `[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]`
         *
         * In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("`chroot`"). To do this, you can set `Entry` to `/` and set `Target` to the `HomeDirectory` parameter value.
         *
         * The following is an `Entry` and `Target` pair example for `chroot`.
         *
         * `[ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]`
         */
        public var homeDirectoryMappings: List<HomeDirectoryMapEntry>? = null
        /**
         * The type of landing directory (folder) that you want your users' home directory to be when they log in to the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or Amazon EFS paths visible to your users.
         */
        public var homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = null
        /**
         * A session policy for your user so that you can use the same Identity and Access Management (IAM) role across multiple users. This policy scopes down a user's access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`.
         *
         * This policy applies only when the domain of `ServerId` is Amazon S3. Amazon EFS does not use session policies.
         *
         * For session policies, Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the `Policy` argument.
         *
         * For an example of a session policy, see [Example session policy](https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html).
         *
         * For more information, see [AssumeRole](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html) in the *Security Token Service API Reference*.
         */
        public var policy: kotlin.String? = null
        /**
         * The full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
         */
        public var posixProfile: aws.sdk.kotlin.services.transfer.model.PosixProfile? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
         */
        public var role: kotlin.String? = null
        /**
         * A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.
         */
        public var serverId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.CreateAccessRequest) : this() {
            this.externalId = x.externalId
            this.homeDirectory = x.homeDirectory
            this.homeDirectoryMappings = x.homeDirectoryMappings
            this.homeDirectoryType = x.homeDirectoryType
            this.policy = x.policy
            this.posixProfile = x.posixProfile
            this.role = x.role
            this.serverId = x.serverId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.CreateAccessRequest = CreateAccessRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.PosixProfile] inside the given [block]
         */
        public fun posixProfile(block: aws.sdk.kotlin.services.transfer.model.PosixProfile.Builder.() -> kotlin.Unit) {
            this.posixProfile = aws.sdk.kotlin.services.transfer.model.PosixProfile.invoke(block)
        }
    }
}
