// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



public class CreateConnectorRequest private constructor(builder: Builder) {
    /**
     * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths`. We use the file’s parent directory (for example, for `--send-file-paths /bucket/dir/file.txt`, parent directory is `/bucket/dir/`) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the `AccessRole` needs to provide read and write access to the parent directory of the file location used in the `StartFileTransfer` request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with `StartFileTransfer`.
     */
    public val accessRole: kotlin.String? = builder.accessRole
    /**
     * A structure that contains the parameters for a connector object.
     */
    public val as2Config: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig? = builder.as2Config
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch logs.
     */
    public val loggingRole: kotlin.String? = builder.loggingRole
    /**
     * Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors for any purpose.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The URL of the partner's AS2 endpoint.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.CreateConnectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectorRequest(")
        append("accessRole=$accessRole,")
        append("as2Config=$as2Config,")
        append("loggingRole=$loggingRole,")
        append("tags=$tags,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessRole?.hashCode() ?: 0
        result = 31 * result + (as2Config?.hashCode() ?: 0)
        result = 31 * result + (loggingRole?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectorRequest

        if (accessRole != other.accessRole) return false
        if (as2Config != other.as2Config) return false
        if (loggingRole != other.loggingRole) return false
        if (tags != other.tags) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.CreateConnectorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths`. We use the file’s parent directory (for example, for `--send-file-paths /bucket/dir/file.txt`, parent directory is `/bucket/dir/`) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the `AccessRole` needs to provide read and write access to the parent directory of the file location used in the `StartFileTransfer` request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with `StartFileTransfer`.
         */
        public var accessRole: kotlin.String? = null
        /**
         * A structure that contains the parameters for a connector object.
         */
        public var as2Config: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch logs.
         */
        public var loggingRole: kotlin.String? = null
        /**
         * Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors for any purpose.
         */
        public var tags: List<Tag>? = null
        /**
         * The URL of the partner's AS2 endpoint.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.CreateConnectorRequest) : this() {
            this.accessRole = x.accessRole
            this.as2Config = x.as2Config
            this.loggingRole = x.loggingRole
            this.tags = x.tags
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.CreateConnectorRequest = CreateConnectorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig] inside the given [block]
         */
        public fun as2Config(block: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig.Builder.() -> kotlin.Unit) {
            this.as2Config = aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig.invoke(block)
        }
    }
}
